/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.GetTopicRuleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetTopicRuleRequestMarshaller
implements Marshaller<Request<GetTopicRuleRequest>, GetTopicRuleRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetTopicRuleRequest> marshall(GetTopicRuleRequest getTopicRuleRequest) {
        if (getTopicRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetTopicRuleRequest> request = new DefaultRequest<GetTopicRuleRequest>(getTopicRuleRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/rules/{ruleName}";
        uriResourcePath = uriResourcePath.replace("{ruleName}", getTopicRuleRequest.getRuleName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getTopicRuleRequest.getRuleName()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

