/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Container;
import com.amazonaws.services.ecs.model.Task;
import com.amazonaws.services.ecs.model.transform.ContainerJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.TaskOverrideJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class TaskJsonMarshaller {
    private static TaskJsonMarshaller instance;

    public void marshall(Task task, JSONWriter jsonWriter) {
        if (task == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList containersList;
            jsonWriter.object();
            if (task.getTaskArn() != null) {
                jsonWriter.key("taskArn").value(task.getTaskArn());
            }
            if (task.getClusterArn() != null) {
                jsonWriter.key("clusterArn").value(task.getClusterArn());
            }
            if (task.getTaskDefinitionArn() != null) {
                jsonWriter.key("taskDefinitionArn").value(task.getTaskDefinitionArn());
            }
            if (task.getContainerInstanceArn() != null) {
                jsonWriter.key("containerInstanceArn").value(task.getContainerInstanceArn());
            }
            if (task.getOverrides() != null) {
                jsonWriter.key("overrides");
                TaskOverrideJsonMarshaller.getInstance().marshall(task.getOverrides(), jsonWriter);
            }
            if (task.getLastStatus() != null) {
                jsonWriter.key("lastStatus").value(task.getLastStatus());
            }
            if (task.getDesiredStatus() != null) {
                jsonWriter.key("desiredStatus").value(task.getDesiredStatus());
            }
            if (!(containersList = (SdkInternalList)task.getContainers()).isEmpty() || !containersList.isAutoConstruct()) {
                jsonWriter.key("containers");
                jsonWriter.array();
                for (Container containersListValue : containersList) {
                    if (containersListValue == null) continue;
                    ContainerJsonMarshaller.getInstance().marshall(containersListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (task.getStartedBy() != null) {
                jsonWriter.key("startedBy").value(task.getStartedBy());
            }
            if (task.getStoppedReason() != null) {
                jsonWriter.key("stoppedReason").value(task.getStoppedReason());
            }
            if (task.getCreatedAt() != null) {
                jsonWriter.key("createdAt").value(task.getCreatedAt());
            }
            if (task.getStartedAt() != null) {
                jsonWriter.key("startedAt").value(task.getStartedAt());
            }
            if (task.getStoppedAt() != null) {
                jsonWriter.key("stoppedAt").value(task.getStoppedAt());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TaskJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TaskJsonMarshaller();
        }
        return instance;
    }
}

