/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeHostsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<String> hostIds;
    private String nextToken;
    private Integer maxResults;
    private ListWithAutoConstructFlag<Filter> filter;

    public List<String> getHostIds() {
        if (this.hostIds == null) {
            this.hostIds = new ListWithAutoConstructFlag();
            this.hostIds.setAutoConstruct(true);
        }
        return this.hostIds;
    }

    public void setHostIds(Collection<String> hostIds) {
        if (hostIds == null) {
            this.hostIds = null;
            return;
        }
        ListWithAutoConstructFlag hostIdsCopy = new ListWithAutoConstructFlag(hostIds.size());
        hostIdsCopy.addAll(hostIds);
        this.hostIds = hostIdsCopy;
    }

    public DescribeHostsRequest withHostIds(String ... hostIds) {
        if (this.getHostIds() == null) {
            this.setHostIds(new ArrayList<String>(hostIds.length));
        }
        for (String value : hostIds) {
            this.getHostIds().add(value);
        }
        return this;
    }

    public DescribeHostsRequest withHostIds(Collection<String> hostIds) {
        if (hostIds == null) {
            this.hostIds = null;
        } else {
            ListWithAutoConstructFlag hostIdsCopy = new ListWithAutoConstructFlag(hostIds.size());
            hostIdsCopy.addAll(hostIds);
            this.hostIds = hostIdsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeHostsRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public DescribeHostsRequest withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public List<Filter> getFilter() {
        if (this.filter == null) {
            this.filter = new ListWithAutoConstructFlag();
            this.filter.setAutoConstruct(true);
        }
        return this.filter;
    }

    public void setFilter(Collection<Filter> filter) {
        if (filter == null) {
            this.filter = null;
            return;
        }
        ListWithAutoConstructFlag filterCopy = new ListWithAutoConstructFlag(filter.size());
        filterCopy.addAll(filter);
        this.filter = filterCopy;
    }

    public DescribeHostsRequest withFilter(Filter ... filter) {
        if (this.getFilter() == null) {
            this.setFilter(new ArrayList<Filter>(filter.length));
        }
        for (Filter value : filter) {
            this.getFilter().add(value);
        }
        return this;
    }

    public DescribeHostsRequest withFilter(Collection<Filter> filter) {
        if (filter == null) {
            this.filter = null;
        } else {
            ListWithAutoConstructFlag filterCopy = new ListWithAutoConstructFlag(filter.size());
            filterCopy.addAll(filter);
            this.filter = filterCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHostIds() != null) {
            sb.append("HostIds: " + this.getHostIds() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults() + ",");
        }
        if (this.getFilter() != null) {
            sb.append("Filter: " + this.getFilter());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHostIds() == null ? 0 : this.getHostIds().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getFilter() == null ? 0 : this.getFilter().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostsRequest)) {
            return false;
        }
        DescribeHostsRequest other = (DescribeHostsRequest)obj;
        if (other.getHostIds() == null ^ this.getHostIds() == null) {
            return false;
        }
        if (other.getHostIds() != null && !other.getHostIds().equals(this.getHostIds())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getFilter() == null ^ this.getFilter() == null) {
            return false;
        }
        return other.getFilter() == null || other.getFilter().equals(this.getFilter());
    }

    @Override
    public DescribeHostsRequest clone() {
        return (DescribeHostsRequest)super.clone();
    }
}

