/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.datapipeline.model.RemoveTagsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class RemoveTagsRequestMarshaller
implements Marshaller<Request<RemoveTagsRequest>, RemoveTagsRequest> {
    @Override
    public Request<RemoveTagsRequest> marshall(RemoveTagsRequest removeTagsRequest) {
        if (removeTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RemoveTagsRequest> request = new DefaultRequest<RemoveTagsRequest>(removeTagsRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.RemoveTags");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tagKeysList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (removeTagsRequest.getPipelineId() != null) {
                jsonWriter.key("pipelineId").value(removeTagsRequest.getPipelineId());
            }
            if (!(tagKeysList = (SdkInternalList)removeTagsRequest.getTagKeys()).isEmpty() || !tagKeysList.isAutoConstruct()) {
                jsonWriter.key("tagKeys");
                jsonWriter.array();
                for (String tagKeysListValue : tagKeysList) {
                    if (tagKeysListValue == null) continue;
                    jsonWriter.value(tagKeysListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

