/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codepipeline.model.ActionConfigurationProperty;
import com.amazonaws.services.codepipeline.model.ActionType;
import com.amazonaws.services.codepipeline.model.transform.ActionConfigurationPropertyJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ActionTypeIdJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ActionTypeSettingsJsonMarshaller;
import com.amazonaws.services.codepipeline.model.transform.ArtifactDetailsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class ActionTypeJsonMarshaller {
    private static ActionTypeJsonMarshaller instance;

    public void marshall(ActionType actionType, JSONWriter jsonWriter) {
        if (actionType == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<ActionConfigurationProperty> actionConfigurationPropertiesList;
            jsonWriter.object();
            if (actionType.getId() != null) {
                jsonWriter.key("id");
                ActionTypeIdJsonMarshaller.getInstance().marshall(actionType.getId(), jsonWriter);
            }
            if (actionType.getSettings() != null) {
                jsonWriter.key("settings");
                ActionTypeSettingsJsonMarshaller.getInstance().marshall(actionType.getSettings(), jsonWriter);
            }
            if ((actionConfigurationPropertiesList = actionType.getActionConfigurationProperties()) != null) {
                jsonWriter.key("actionConfigurationProperties");
                jsonWriter.array();
                for (ActionConfigurationProperty actionConfigurationPropertiesListValue : actionConfigurationPropertiesList) {
                    if (actionConfigurationPropertiesListValue == null) continue;
                    ActionConfigurationPropertyJsonMarshaller.getInstance().marshall(actionConfigurationPropertiesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (actionType.getInputArtifactDetails() != null) {
                jsonWriter.key("inputArtifactDetails");
                ArtifactDetailsJsonMarshaller.getInstance().marshall(actionType.getInputArtifactDetails(), jsonWriter);
            }
            if (actionType.getOutputArtifactDetails() != null) {
                jsonWriter.key("outputArtifactDetails");
                ArtifactDetailsJsonMarshaller.getInstance().marshall(actionType.getOutputArtifactDetails(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ActionTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ActionTypeJsonMarshaller();
        }
        return instance;
    }
}

