/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.opsworks.model.DescribeAgentVersionsRequest;
import com.amazonaws.services.opsworks.model.StackConfigurationManager;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeAgentVersionsRequestMarshaller
implements Marshaller<Request<DescribeAgentVersionsRequest>, DescribeAgentVersionsRequest> {
    @Override
    public Request<DescribeAgentVersionsRequest> marshall(DescribeAgentVersionsRequest describeAgentVersionsRequest) {
        if (describeAgentVersionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeAgentVersionsRequest> request = new DefaultRequest<DescribeAgentVersionsRequest>(describeAgentVersionsRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.DescribeAgentVersions";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StackConfigurationManager configurationManager;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeAgentVersionsRequest.getStackId() != null) {
                jsonWriter.key("StackId").value(describeAgentVersionsRequest.getStackId());
            }
            if ((configurationManager = describeAgentVersionsRequest.getConfigurationManager()) != null) {
                jsonWriter.key("ConfigurationManager");
                jsonWriter.object();
                if (configurationManager.getName() != null) {
                    jsonWriter.key("Name").value(configurationManager.getName());
                }
                if (configurationManager.getVersion() != null) {
                    jsonWriter.key("Version").value(configurationManager.getVersion());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

