/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.service.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.service.codecommit.model.ListRepositoriesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListRepositoriesRequestMarshaller
implements Marshaller<Request<ListRepositoriesRequest>, ListRepositoriesRequest> {
    @Override
    public Request<ListRepositoriesRequest> marshall(ListRepositoriesRequest listRepositoriesRequest) {
        if (listRepositoriesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListRepositoriesRequest> request = new DefaultRequest<ListRepositoriesRequest>(listRepositoriesRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.ListRepositories");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listRepositoriesRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(listRepositoriesRequest.getNextToken());
            }
            if (listRepositoriesRequest.getSortBy() != null) {
                jsonWriter.key("sortBy").value(listRepositoriesRequest.getSortBy());
            }
            if (listRepositoriesRequest.getOrder() != null) {
                jsonWriter.key("order").value(listRepositoriesRequest.getOrder());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

