/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.service.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.service.codecommit.model.CreateBranchRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateBranchRequestMarshaller
implements Marshaller<Request<CreateBranchRequest>, CreateBranchRequest> {
    @Override
    public Request<CreateBranchRequest> marshall(CreateBranchRequest createBranchRequest) {
        if (createBranchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateBranchRequest> request = new DefaultRequest<CreateBranchRequest>(createBranchRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.CreateBranch");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createBranchRequest.getRepositoryName() != null) {
                jsonWriter.key("repositoryName").value(createBranchRequest.getRepositoryName());
            }
            if (createBranchRequest.getBranchName() != null) {
                jsonWriter.key("branchName").value(createBranchRequest.getBranchName());
            }
            if (createBranchRequest.getCommitId() != null) {
                jsonWriter.key("commitId").value(createBranchRequest.getCommitId());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

