/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.waf.model.CreateWebACLRequest;
import com.amazonaws.services.waf.model.transform.WafActionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateWebACLRequestMarshaller
implements Marshaller<Request<CreateWebACLRequest>, CreateWebACLRequest> {
    @Override
    public Request<CreateWebACLRequest> marshall(CreateWebACLRequest createWebACLRequest) {
        if (createWebACLRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateWebACLRequest> request = new DefaultRequest<CreateWebACLRequest>(createWebACLRequest, "AWSWAF");
        request.addHeader("X-Amz-Target", "AWSWAF_20150824.CreateWebACL");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createWebACLRequest.getName() != null) {
                jsonWriter.key("Name").value(createWebACLRequest.getName());
            }
            if (createWebACLRequest.getMetricName() != null) {
                jsonWriter.key("MetricName").value(createWebACLRequest.getMetricName());
            }
            if (createWebACLRequest.getDefaultAction() != null) {
                jsonWriter.key("DefaultAction");
                WafActionJsonMarshaller.getInstance().marshall(createWebACLRequest.getDefaultAction(), jsonWriter);
            }
            if (createWebACLRequest.getChangeToken() != null) {
                jsonWriter.key("ChangeToken").value(createWebACLRequest.getChangeToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

