/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.InstanceStatus;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceStateChangeReasonJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceTimelineJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class InstanceStatusJsonMarshaller {
    private static InstanceStatusJsonMarshaller instance;

    public void marshall(InstanceStatus instanceStatus, JSONWriter jsonWriter) {
        if (instanceStatus == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (instanceStatus.getState() != null) {
                jsonWriter.key("State").value(instanceStatus.getState());
            }
            if (instanceStatus.getStateChangeReason() != null) {
                jsonWriter.key("StateChangeReason");
                InstanceStateChangeReasonJsonMarshaller.getInstance().marshall(instanceStatus.getStateChangeReason(), jsonWriter);
            }
            if (instanceStatus.getTimeline() != null) {
                jsonWriter.key("Timeline");
                InstanceTimelineJsonMarshaller.getInstance().marshall(instanceStatus.getTimeline(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceStatusJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceStatusJsonMarshaller();
        }
        return instance;
    }
}

