/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecs.model.Attribute;
import com.amazonaws.util.json.JSONWriter;

public class AttributeJsonMarshaller {
    private static AttributeJsonMarshaller instance;

    public void marshall(Attribute attribute, JSONWriter jsonWriter) {
        if (attribute == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (attribute.getName() != null) {
                jsonWriter.key("name").value(attribute.getName());
            }
            if (attribute.getValue() != null) {
                jsonWriter.key("value").value(attribute.getValue());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AttributeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AttributeJsonMarshaller();
        }
        return instance;
    }
}

