/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.ListStreamsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListStreamsRequestMarshaller
implements Marshaller<Request<ListStreamsRequest>, ListStreamsRequest> {
    @Override
    public Request<ListStreamsRequest> marshall(ListStreamsRequest listStreamsRequest) {
        if (listStreamsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListStreamsRequest> request = new DefaultRequest<ListStreamsRequest>(listStreamsRequest, "AmazonDynamoDBStreams");
        request.addHeader("X-Amz-Target", "DynamoDBStreams_20120810.ListStreams");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listStreamsRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(listStreamsRequest.getTableName());
            }
            if (listStreamsRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(listStreamsRequest.getLimit());
            }
            if (listStreamsRequest.getExclusiveStartStreamArn() != null) {
                jsonWriter.key("ExclusiveStartStreamArn").value(listStreamsRequest.getExclusiveStartStreamArn());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

