/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchema;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchemas;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBReflector;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class DynamoDBMapperConfig {
    private final SaveBehavior saveBehavior;
    private final ConsistentReads consistentReads;
    private final TableNameOverride tableNameOverride;
    private final TableNameResolver tableNameResolver;
    private final ObjectTableNameResolver objectTableNameResolver;
    private final PaginationLoadingStrategy paginationLoadingStrategy;
    private final RequestMetricCollector requestMetricCollector;
    private final ConversionSchema conversionSchema;
    private final BatchWriteRetryStrategy batchWriteRetryStrategy;
    public static final DynamoDBMapperConfig DEFAULT = new DynamoDBMapperConfig(SaveBehavior.UPDATE, ConsistentReads.EVENTUAL, null, null, null, PaginationLoadingStrategy.LAZY_LOADING, null, ConversionSchemas.DEFAULT, new DefaultBatchWriteRetryStrategy());

    @Deprecated
    public DynamoDBMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride) {
        this(saveBehavior, consistentReads, tableNameOverride, null, null);
    }

    @Deprecated
    public DynamoDBMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride, PaginationLoadingStrategy paginationLoadingStrategy) {
        this(saveBehavior, consistentReads, tableNameOverride, paginationLoadingStrategy, null);
    }

    @Deprecated
    public DynamoDBMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride, PaginationLoadingStrategy paginationLoadingStrategy, RequestMetricCollector requestMetricCollector) {
        this(saveBehavior, consistentReads, tableNameOverride, null, null, paginationLoadingStrategy, requestMetricCollector, ConversionSchemas.DEFAULT, new DefaultBatchWriteRetryStrategy());
    }

    private DynamoDBMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride, TableNameResolver tableNameResolver, ObjectTableNameResolver objectTableNameResolver, PaginationLoadingStrategy paginationLoadingStrategy, RequestMetricCollector requestMetricCollector, ConversionSchema conversionSchema, BatchWriteRetryStrategy batchWriteRetryStrategy) {
        this.saveBehavior = saveBehavior;
        this.consistentReads = consistentReads;
        this.tableNameOverride = tableNameOverride;
        this.tableNameResolver = tableNameResolver;
        this.objectTableNameResolver = objectTableNameResolver;
        this.paginationLoadingStrategy = paginationLoadingStrategy;
        this.requestMetricCollector = requestMetricCollector;
        this.conversionSchema = conversionSchema;
        this.batchWriteRetryStrategy = batchWriteRetryStrategy;
    }

    public DynamoDBMapperConfig(SaveBehavior saveBehavior) {
        this(saveBehavior, null, null, null, null, null, null, ConversionSchemas.DEFAULT, new DefaultBatchWriteRetryStrategy());
    }

    public DynamoDBMapperConfig(ConsistentReads consistentReads) {
        this(null, consistentReads, null, null, null, null, null, ConversionSchemas.DEFAULT, new DefaultBatchWriteRetryStrategy());
    }

    public DynamoDBMapperConfig(TableNameOverride tableNameOverride) {
        this(null, null, tableNameOverride, null, null, null, null, ConversionSchemas.DEFAULT, new DefaultBatchWriteRetryStrategy());
    }

    public DynamoDBMapperConfig(TableNameResolver tableNameResolver) {
        this(null, null, null, tableNameResolver, null, null, null, ConversionSchemas.DEFAULT, new DefaultBatchWriteRetryStrategy());
    }

    public DynamoDBMapperConfig(ObjectTableNameResolver objectTableNameResolver) {
        this(null, null, null, null, objectTableNameResolver, null, null, ConversionSchemas.DEFAULT, new DefaultBatchWriteRetryStrategy());
    }

    public DynamoDBMapperConfig(TableNameResolver tableNameResolver, ObjectTableNameResolver objectTableNameResolver) {
        this(null, null, null, tableNameResolver, objectTableNameResolver, null, null, ConversionSchemas.DEFAULT, new DefaultBatchWriteRetryStrategy());
    }

    public DynamoDBMapperConfig(PaginationLoadingStrategy paginationLoadingStrategy) {
        this(null, null, null, null, null, paginationLoadingStrategy, null, ConversionSchemas.DEFAULT, new DefaultBatchWriteRetryStrategy());
    }

    public DynamoDBMapperConfig(ConversionSchema conversionSchema) {
        this(null, null, null, null, null, null, null, conversionSchema, new DefaultBatchWriteRetryStrategy());
    }

    public DynamoDBMapperConfig(DynamoDBMapperConfig defaults, DynamoDBMapperConfig overrides) {
        if (overrides == null) {
            this.saveBehavior = defaults.getSaveBehavior();
            this.consistentReads = defaults.getConsistentReads();
            this.tableNameOverride = defaults.getTableNameOverride();
            this.tableNameResolver = defaults.getTableNameResolver();
            this.objectTableNameResolver = defaults.getObjectTableNameResolver();
            this.paginationLoadingStrategy = defaults.getPaginationLoadingStrategy();
            this.requestMetricCollector = defaults.getRequestMetricCollector();
            this.conversionSchema = defaults.getConversionSchema();
            this.batchWriteRetryStrategy = defaults.getBatchWriteRetryStrategy();
        } else {
            this.saveBehavior = overrides.getSaveBehavior() == null ? defaults.getSaveBehavior() : overrides.getSaveBehavior();
            this.consistentReads = overrides.getConsistentReads() == null ? defaults.getConsistentReads() : overrides.getConsistentReads();
            this.tableNameOverride = overrides.getTableNameOverride() == null ? defaults.getTableNameOverride() : overrides.getTableNameOverride();
            this.tableNameResolver = overrides.getTableNameResolver() == null ? defaults.getTableNameResolver() : overrides.getTableNameResolver();
            this.objectTableNameResolver = overrides.getObjectTableNameResolver() == null ? defaults.getObjectTableNameResolver() : overrides.getObjectTableNameResolver();
            this.paginationLoadingStrategy = overrides.getPaginationLoadingStrategy() == null ? defaults.getPaginationLoadingStrategy() : overrides.getPaginationLoadingStrategy();
            this.requestMetricCollector = overrides.getRequestMetricCollector() == null ? defaults.getRequestMetricCollector() : overrides.getRequestMetricCollector();
            this.conversionSchema = overrides.getConversionSchema() == null ? defaults.getConversionSchema() : overrides.getConversionSchema();
            this.batchWriteRetryStrategy = overrides.getBatchWriteRetryStrategy() == null ? defaults.getBatchWriteRetryStrategy() : overrides.getBatchWriteRetryStrategy();
        }
    }

    public SaveBehavior getSaveBehavior() {
        return this.saveBehavior;
    }

    public ConsistentReads getConsistentReads() {
        return this.consistentReads;
    }

    public TableNameOverride getTableNameOverride() {
        return this.tableNameOverride;
    }

    public TableNameResolver getTableNameResolver() {
        return this.tableNameResolver;
    }

    public ObjectTableNameResolver getObjectTableNameResolver() {
        return this.objectTableNameResolver;
    }

    public PaginationLoadingStrategy getPaginationLoadingStrategy() {
        return this.paginationLoadingStrategy;
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public ConversionSchema getConversionSchema() {
        return this.conversionSchema;
    }

    public BatchWriteRetryStrategy getBatchWriteRetryStrategy() {
        return this.batchWriteRetryStrategy;
    }

    public static class DefaultBatchWriteRetryStrategy
    implements BatchWriteRetryStrategy {
        private static final long MAX_BACKOFF_IN_MILLISECONDS = 3000L;
        private static final int DEFAULT_MAX_RETRY = -1;
        private final int maxRetry;

        public DefaultBatchWriteRetryStrategy() {
            this(-1);
        }

        public DefaultBatchWriteRetryStrategy(int maxRetry) {
            this.maxRetry = maxRetry;
        }

        @Override
        public int getMaxRetryOnUnprocessedItems(Map<String, List<WriteRequest>> batchWriteItemInput) {
            return this.maxRetry;
        }

        @Override
        public long getDelayBeforeRetryUnprocessedItems(Map<String, List<WriteRequest>> unprocessedItems, int retriesAttempted) {
            if (retriesAttempted < 0) {
                return 0L;
            }
            Random random = new Random();
            long scaleFactor = 1000 + random.nextInt(200);
            long delay = (long)(Math.pow(2.0, retriesAttempted) * (double)scaleFactor);
            return Math.min(delay, 3000L);
        }
    }

    public static interface BatchWriteRetryStrategy {
        public int getMaxRetryOnUnprocessedItems(Map<String, List<WriteRequest>> var1);

        public long getDelayBeforeRetryUnprocessedItems(Map<String, List<WriteRequest>> var1, int var2);
    }

    public static class DefaultTableNameResolver
    implements TableNameResolver {
        public static final DefaultTableNameResolver INSTANCE = new DefaultTableNameResolver();
        private final DynamoDBReflector reflector = new DynamoDBReflector();

        @Override
        public String getTableName(Class<?> clazz, DynamoDBMapperConfig config) {
            String tableName;
            TableNameOverride override = config.getTableNameOverride();
            if (override != null && (tableName = override.getTableName()) != null) {
                return tableName;
            }
            tableName = this.reflector.getTable(clazz).tableName();
            String prefix = override == null ? null : override.getTableNamePrefix();
            return prefix == null ? tableName : prefix + tableName;
        }
    }

    public static interface ObjectTableNameResolver {
        public String getTableName(Object var1, DynamoDBMapperConfig var2);
    }

    public static interface TableNameResolver {
        public String getTableName(Class<?> var1, DynamoDBMapperConfig var2);
    }

    public static final class TableNameOverride {
        private final String tableNameOverride;
        private final String tableNamePrefix;

        public static TableNameOverride withTableNamePrefix(String tableNamePrefix) {
            return new TableNameOverride(null, tableNamePrefix);
        }

        public static TableNameOverride withTableNameReplacement(String tableNameReplacement) {
            return new TableNameOverride(tableNameReplacement, null);
        }

        private TableNameOverride(String tableNameOverride, String tableNamePrefix) {
            this.tableNameOverride = tableNameOverride;
            this.tableNamePrefix = tableNamePrefix;
        }

        public TableNameOverride(String tableNameOverride) {
            this(tableNameOverride, null);
        }

        public String getTableName() {
            return this.tableNameOverride;
        }

        public String getTableNamePrefix() {
            return this.tableNamePrefix;
        }
    }

    public static enum PaginationLoadingStrategy {
        LAZY_LOADING,
        ITERATION_ONLY,
        EAGER_LOADING;

    }

    public static enum ConsistentReads {
        CONSISTENT,
        EVENTUAL;

    }

    public static enum SaveBehavior {
        UPDATE,
        UPDATE_SKIP_NULL_ATTRIBUTES,
        CLOBBER,
        APPEND_SET;

    }

    public static class Builder {
        private SaveBehavior saveBehavior = DEFAULT.getSaveBehavior();
        private ConsistentReads consistentReads = DEFAULT.getConsistentReads();
        private TableNameOverride tableNameOverride = DEFAULT.getTableNameOverride();
        private TableNameResolver tableNameResolver = DEFAULT.getTableNameResolver();
        private ObjectTableNameResolver objectTableNameResolver = DEFAULT.getObjectTableNameResolver();
        private PaginationLoadingStrategy paginationLoadingStrategy = DEFAULT.getPaginationLoadingStrategy();
        private RequestMetricCollector requestMetricCollector = DEFAULT.getRequestMetricCollector();
        private ConversionSchema conversionSchema = DEFAULT.getConversionSchema();
        private BatchWriteRetryStrategy batchWriteRetryStrategy = DEFAULT.getBatchWriteRetryStrategy();

        public SaveBehavior getSaveBehavior() {
            return this.saveBehavior;
        }

        public void setSaveBehavior(SaveBehavior value) {
            this.saveBehavior = value;
        }

        public Builder withSaveBehavior(SaveBehavior value) {
            this.setSaveBehavior(value);
            return this;
        }

        public ConsistentReads getConsistentReads() {
            return this.consistentReads;
        }

        public void setConsistentReads(ConsistentReads value) {
            this.consistentReads = value;
        }

        public Builder withConsistentReads(ConsistentReads value) {
            this.setConsistentReads(value);
            return this;
        }

        public TableNameOverride getTableNameOverride() {
            return this.tableNameOverride;
        }

        public void setTableNameOverride(TableNameOverride value) {
            this.tableNameOverride = value;
        }

        public Builder withTableNameOverride(TableNameOverride value) {
            this.setTableNameOverride(value);
            return this;
        }

        public TableNameResolver getTableNameResolver() {
            return this.tableNameResolver;
        }

        public void setTableNameResolver(TableNameResolver value) {
            this.tableNameResolver = value;
        }

        public Builder withTableNameResolver(TableNameResolver value) {
            this.setTableNameResolver(value);
            return this;
        }

        public ObjectTableNameResolver getObjectTableNameResolver() {
            return this.objectTableNameResolver;
        }

        public void setObjectTableNameResolver(ObjectTableNameResolver value) {
            this.objectTableNameResolver = value;
        }

        public Builder withObjectTableNameResolver(ObjectTableNameResolver value) {
            this.setObjectTableNameResolver(value);
            return this;
        }

        public PaginationLoadingStrategy getPaginationLoadingStrategy() {
            return this.paginationLoadingStrategy;
        }

        public void setPaginationLoadingStrategy(PaginationLoadingStrategy value) {
            this.paginationLoadingStrategy = value;
        }

        public Builder withPaginationLoadingStrategy(PaginationLoadingStrategy value) {
            this.setPaginationLoadingStrategy(value);
            return this;
        }

        public RequestMetricCollector getRequestMetricCollector() {
            return this.requestMetricCollector;
        }

        public void setRequestMetricCollector(RequestMetricCollector value) {
            this.requestMetricCollector = value;
        }

        public Builder withRequestMetricCollector(RequestMetricCollector value) {
            this.setRequestMetricCollector(value);
            return this;
        }

        public ConversionSchema getConversionSchema() {
            return this.conversionSchema;
        }

        public void setConversionSchema(ConversionSchema value) {
            this.conversionSchema = value;
        }

        public Builder withConversionSchema(ConversionSchema value) {
            this.setConversionSchema(value);
            return this;
        }

        public BatchWriteRetryStrategy getBatchWriteRetryStrategy() {
            return this.batchWriteRetryStrategy;
        }

        public void setBatchWriteRetryStrategy(BatchWriteRetryStrategy value) {
            this.batchWriteRetryStrategy = value;
        }

        public Builder withBatchWriteRetryStrategy(BatchWriteRetryStrategy value) {
            this.setBatchWriteRetryStrategy(value);
            return this;
        }

        public DynamoDBMapperConfig build() {
            return new DynamoDBMapperConfig(this.saveBehavior, this.consistentReads, this.tableNameOverride, this.tableNameResolver, this.objectTableNameResolver, this.paginationLoadingStrategy, this.requestMetricCollector, this.conversionSchema, this.batchWriteRetryStrategy);
        }
    }
}

