/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.DescribeTrustsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeTrustsRequestMarshaller
implements Marshaller<Request<DescribeTrustsRequest>, DescribeTrustsRequest> {
    @Override
    public Request<DescribeTrustsRequest> marshall(DescribeTrustsRequest describeTrustsRequest) {
        if (describeTrustsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeTrustsRequest> request = new DefaultRequest<DescribeTrustsRequest>(describeTrustsRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.DescribeTrusts");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList trustIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeTrustsRequest.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value(describeTrustsRequest.getDirectoryId());
            }
            if (!(trustIdsList = (SdkInternalList)describeTrustsRequest.getTrustIds()).isEmpty() || !trustIdsList.isAutoConstruct()) {
                jsonWriter.key("TrustIds");
                jsonWriter.array();
                for (String trustIdsListValue : trustIdsList) {
                    if (trustIdsListValue == null) continue;
                    jsonWriter.value(trustIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (describeTrustsRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(describeTrustsRequest.getNextToken());
            }
            if (describeTrustsRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(describeTrustsRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

