/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.SetIdentityPoolRolesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

public class SetIdentityPoolRolesRequestMarshaller
implements Marshaller<Request<SetIdentityPoolRolesRequest>, SetIdentityPoolRolesRequest> {
    @Override
    public Request<SetIdentityPoolRolesRequest> marshall(SetIdentityPoolRolesRequest setIdentityPoolRolesRequest) {
        if (setIdentityPoolRolesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetIdentityPoolRolesRequest> request = new DefaultRequest<SetIdentityPoolRolesRequest>(setIdentityPoolRolesRequest, "AmazonCognitoIdentity");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityService.SetIdentityPoolRoles");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, String> rolesMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (setIdentityPoolRolesRequest.getIdentityPoolId() != null) {
                jsonWriter.key("IdentityPoolId").value(setIdentityPoolRolesRequest.getIdentityPoolId());
            }
            if ((rolesMap = setIdentityPoolRolesRequest.getRoles()) != null) {
                jsonWriter.key("Roles");
                jsonWriter.object();
                for (Map.Entry<String, String> rolesMapValue : rolesMap.entrySet()) {
                    if (rolesMapValue.getValue() == null) continue;
                    jsonWriter.key(rolesMapValue.getKey());
                    jsonWriter.value(rolesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

