/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.Model;
import com.amazonaws.util.json.JSONWriter;

public class ModelJsonMarshaller {
    private static ModelJsonMarshaller instance;

    public void marshall(Model model, JSONWriter jsonWriter) {
        if (model == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (model.getId() != null) {
                jsonWriter.key("id").value(model.getId());
            }
            if (model.getName() != null) {
                jsonWriter.key("name").value(model.getName());
            }
            if (model.getDescription() != null) {
                jsonWriter.key("description").value(model.getDescription());
            }
            if (model.getSchema() != null) {
                jsonWriter.key("schema").value(model.getSchema());
            }
            if (model.getContentType() != null) {
                jsonWriter.key("contentType").value(model.getContentType());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ModelJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ModelJsonMarshaller();
        }
        return instance;
    }
}

