/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetIntegrationResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetIntegrationResponseRequestMarshaller
implements Marshaller<Request<GetIntegrationResponseRequest>, GetIntegrationResponseRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetIntegrationResponseRequest> marshall(GetIntegrationResponseRequest getIntegrationResponseRequest) {
        if (getIntegrationResponseRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetIntegrationResponseRequest> request = new DefaultRequest<GetIntegrationResponseRequest>(getIntegrationResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getIntegrationResponseRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getIntegrationResponseRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{resource_id}", getIntegrationResponseRequest.getResourceId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getIntegrationResponseRequest.getResourceId()));
        uriResourcePath = uriResourcePath.replace("{http_method}", getIntegrationResponseRequest.getHttpMethod() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getIntegrationResponseRequest.getHttpMethod()));
        uriResourcePath = uriResourcePath.replace("{status_code}", getIntegrationResponseRequest.getStatusCode() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getIntegrationResponseRequest.getStatusCode()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

