/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListHostedZonesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ListHostedZonesRequestMarshaller
implements Marshaller<Request<ListHostedZonesRequest>, ListHostedZonesRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<ListHostedZonesRequest> marshall(ListHostedZonesRequest listHostedZonesRequest) {
        String value;
        String name;
        if (listHostedZonesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListHostedZonesRequest> request = new DefaultRequest<ListHostedZonesRequest>(listHostedZonesRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("Marker")) {
            name = DYNAMIC_QUERY_PARAMS.get("Marker");
            String string = value = listHostedZonesRequest.getMarker() == null ? null : StringUtils.fromString(listHostedZonesRequest.getMarker());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Marker}", listHostedZonesRequest.getMarker() == null ? "" : StringUtils.fromString(listHostedZonesRequest.getMarker()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("MaxItems")) {
            name = DYNAMIC_QUERY_PARAMS.get("MaxItems");
            String string = value = listHostedZonesRequest.getMaxItems() == null ? null : StringUtils.fromString(listHostedZonesRequest.getMaxItems());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{MaxItems}", listHostedZonesRequest.getMaxItems() == null ? "" : StringUtils.fromString(listHostedZonesRequest.getMaxItems()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("DelegationSetId")) {
            name = DYNAMIC_QUERY_PARAMS.get("DelegationSetId");
            String string = value = listHostedZonesRequest.getDelegationSetId() == null ? null : StringUtils.fromString(listHostedZonesRequest.getDelegationSetId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{DelegationSetId}", listHostedZonesRequest.getDelegationSetId() == null ? "" : StringUtils.fromString(listHostedZonesRequest.getDelegationSetId()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        return request;
    }

    static {
        String path = "/2013-04-01/hostedzone?marker={Marker}&maxitems={MaxItems}&delegationsetid={DelegationSetId}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

