/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.RulesPackage;
import com.amazonaws.services.inspector.model.transform.LocalizedTextJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class RulesPackageJsonMarshaller {
    private static RulesPackageJsonMarshaller instance;

    public void marshall(RulesPackage rulesPackage, JSONWriter jsonWriter) {
        if (rulesPackage == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (rulesPackage.getRulesPackageArn() != null) {
                jsonWriter.key("rulesPackageArn").value(rulesPackage.getRulesPackageArn());
            }
            if (rulesPackage.getRulesPackageName() != null) {
                jsonWriter.key("rulesPackageName").value(rulesPackage.getRulesPackageName());
            }
            if (rulesPackage.getVersion() != null) {
                jsonWriter.key("version").value(rulesPackage.getVersion());
            }
            if (rulesPackage.getProvider() != null) {
                jsonWriter.key("provider").value(rulesPackage.getProvider());
            }
            if (rulesPackage.getDescription() != null) {
                jsonWriter.key("description");
                LocalizedTextJsonMarshaller.getInstance().marshall(rulesPackage.getDescription(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RulesPackageJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RulesPackageJsonMarshaller();
        }
        return instance;
    }
}

