/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import com.amazonaws.services.elasticmapreduce.model.PlacementType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class JobFlowInstancesConfig
implements Serializable,
Cloneable {
    private String masterInstanceType;
    private String slaveInstanceType;
    private Integer instanceCount;
    private SdkInternalList<InstanceGroupConfig> instanceGroups;
    private String ec2KeyName;
    private PlacementType placement;
    private Boolean keepJobFlowAliveWhenNoSteps;
    private Boolean terminationProtected;
    private String hadoopVersion;
    private String ec2SubnetId;
    private String emrManagedMasterSecurityGroup;
    private String emrManagedSlaveSecurityGroup;
    private SdkInternalList<String> additionalMasterSecurityGroups;
    private SdkInternalList<String> additionalSlaveSecurityGroups;

    public void setMasterInstanceType(String masterInstanceType) {
        this.masterInstanceType = masterInstanceType;
    }

    public String getMasterInstanceType() {
        return this.masterInstanceType;
    }

    public JobFlowInstancesConfig withMasterInstanceType(String masterInstanceType) {
        this.setMasterInstanceType(masterInstanceType);
        return this;
    }

    public void setSlaveInstanceType(String slaveInstanceType) {
        this.slaveInstanceType = slaveInstanceType;
    }

    public String getSlaveInstanceType() {
        return this.slaveInstanceType;
    }

    public JobFlowInstancesConfig withSlaveInstanceType(String slaveInstanceType) {
        this.setSlaveInstanceType(slaveInstanceType);
        return this;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public JobFlowInstancesConfig withInstanceCount(Integer instanceCount) {
        this.setInstanceCount(instanceCount);
        return this;
    }

    public List<InstanceGroupConfig> getInstanceGroups() {
        if (this.instanceGroups == null) {
            this.instanceGroups = new SdkInternalList();
        }
        return this.instanceGroups;
    }

    public void setInstanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
            return;
        }
        this.instanceGroups = new SdkInternalList<InstanceGroupConfig>(instanceGroups);
    }

    public JobFlowInstancesConfig withInstanceGroups(InstanceGroupConfig ... instanceGroups) {
        if (this.instanceGroups == null) {
            this.setInstanceGroups(new SdkInternalList<InstanceGroupConfig>(instanceGroups.length));
        }
        for (InstanceGroupConfig ele : instanceGroups) {
            this.instanceGroups.add(ele);
        }
        return this;
    }

    public JobFlowInstancesConfig withInstanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
        this.setInstanceGroups(instanceGroups);
        return this;
    }

    public void setEc2KeyName(String ec2KeyName) {
        this.ec2KeyName = ec2KeyName;
    }

    public String getEc2KeyName() {
        return this.ec2KeyName;
    }

    public JobFlowInstancesConfig withEc2KeyName(String ec2KeyName) {
        this.setEc2KeyName(ec2KeyName);
        return this;
    }

    public void setPlacement(PlacementType placement) {
        this.placement = placement;
    }

    public PlacementType getPlacement() {
        return this.placement;
    }

    public JobFlowInstancesConfig withPlacement(PlacementType placement) {
        this.setPlacement(placement);
        return this;
    }

    public void setKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
        this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
    }

    public Boolean getKeepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public JobFlowInstancesConfig withKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
        this.setKeepJobFlowAliveWhenNoSteps(keepJobFlowAliveWhenNoSteps);
        return this;
    }

    public Boolean isKeepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public void setTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
    }

    public Boolean getTerminationProtected() {
        return this.terminationProtected;
    }

    public JobFlowInstancesConfig withTerminationProtected(Boolean terminationProtected) {
        this.setTerminationProtected(terminationProtected);
        return this;
    }

    public Boolean isTerminationProtected() {
        return this.terminationProtected;
    }

    public void setHadoopVersion(String hadoopVersion) {
        this.hadoopVersion = hadoopVersion;
    }

    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    public JobFlowInstancesConfig withHadoopVersion(String hadoopVersion) {
        this.setHadoopVersion(hadoopVersion);
        return this;
    }

    public void setEc2SubnetId(String ec2SubnetId) {
        this.ec2SubnetId = ec2SubnetId;
    }

    public String getEc2SubnetId() {
        return this.ec2SubnetId;
    }

    public JobFlowInstancesConfig withEc2SubnetId(String ec2SubnetId) {
        this.setEc2SubnetId(ec2SubnetId);
        return this;
    }

    public void setEmrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
        this.emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup;
    }

    public String getEmrManagedMasterSecurityGroup() {
        return this.emrManagedMasterSecurityGroup;
    }

    public JobFlowInstancesConfig withEmrManagedMasterSecurityGroup(String emrManagedMasterSecurityGroup) {
        this.setEmrManagedMasterSecurityGroup(emrManagedMasterSecurityGroup);
        return this;
    }

    public void setEmrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
        this.emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup;
    }

    public String getEmrManagedSlaveSecurityGroup() {
        return this.emrManagedSlaveSecurityGroup;
    }

    public JobFlowInstancesConfig withEmrManagedSlaveSecurityGroup(String emrManagedSlaveSecurityGroup) {
        this.setEmrManagedSlaveSecurityGroup(emrManagedSlaveSecurityGroup);
        return this;
    }

    public List<String> getAdditionalMasterSecurityGroups() {
        if (this.additionalMasterSecurityGroups == null) {
            this.additionalMasterSecurityGroups = new SdkInternalList();
        }
        return this.additionalMasterSecurityGroups;
    }

    public void setAdditionalMasterSecurityGroups(Collection<String> additionalMasterSecurityGroups) {
        if (additionalMasterSecurityGroups == null) {
            this.additionalMasterSecurityGroups = null;
            return;
        }
        this.additionalMasterSecurityGroups = new SdkInternalList<String>(additionalMasterSecurityGroups);
    }

    public JobFlowInstancesConfig withAdditionalMasterSecurityGroups(String ... additionalMasterSecurityGroups) {
        if (this.additionalMasterSecurityGroups == null) {
            this.setAdditionalMasterSecurityGroups(new SdkInternalList<String>(additionalMasterSecurityGroups.length));
        }
        for (String ele : additionalMasterSecurityGroups) {
            this.additionalMasterSecurityGroups.add(ele);
        }
        return this;
    }

    public JobFlowInstancesConfig withAdditionalMasterSecurityGroups(Collection<String> additionalMasterSecurityGroups) {
        this.setAdditionalMasterSecurityGroups(additionalMasterSecurityGroups);
        return this;
    }

    public List<String> getAdditionalSlaveSecurityGroups() {
        if (this.additionalSlaveSecurityGroups == null) {
            this.additionalSlaveSecurityGroups = new SdkInternalList();
        }
        return this.additionalSlaveSecurityGroups;
    }

    public void setAdditionalSlaveSecurityGroups(Collection<String> additionalSlaveSecurityGroups) {
        if (additionalSlaveSecurityGroups == null) {
            this.additionalSlaveSecurityGroups = null;
            return;
        }
        this.additionalSlaveSecurityGroups = new SdkInternalList<String>(additionalSlaveSecurityGroups);
    }

    public JobFlowInstancesConfig withAdditionalSlaveSecurityGroups(String ... additionalSlaveSecurityGroups) {
        if (this.additionalSlaveSecurityGroups == null) {
            this.setAdditionalSlaveSecurityGroups(new SdkInternalList<String>(additionalSlaveSecurityGroups.length));
        }
        for (String ele : additionalSlaveSecurityGroups) {
            this.additionalSlaveSecurityGroups.add(ele);
        }
        return this;
    }

    public JobFlowInstancesConfig withAdditionalSlaveSecurityGroups(Collection<String> additionalSlaveSecurityGroups) {
        this.setAdditionalSlaveSecurityGroups(additionalSlaveSecurityGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMasterInstanceType() != null) {
            sb.append("MasterInstanceType: " + this.getMasterInstanceType() + ",");
        }
        if (this.getSlaveInstanceType() != null) {
            sb.append("SlaveInstanceType: " + this.getSlaveInstanceType() + ",");
        }
        if (this.getInstanceCount() != null) {
            sb.append("InstanceCount: " + this.getInstanceCount() + ",");
        }
        if (this.getInstanceGroups() != null) {
            sb.append("InstanceGroups: " + this.getInstanceGroups() + ",");
        }
        if (this.getEc2KeyName() != null) {
            sb.append("Ec2KeyName: " + this.getEc2KeyName() + ",");
        }
        if (this.getPlacement() != null) {
            sb.append("Placement: " + this.getPlacement() + ",");
        }
        if (this.getKeepJobFlowAliveWhenNoSteps() != null) {
            sb.append("KeepJobFlowAliveWhenNoSteps: " + this.getKeepJobFlowAliveWhenNoSteps() + ",");
        }
        if (this.getTerminationProtected() != null) {
            sb.append("TerminationProtected: " + this.getTerminationProtected() + ",");
        }
        if (this.getHadoopVersion() != null) {
            sb.append("HadoopVersion: " + this.getHadoopVersion() + ",");
        }
        if (this.getEc2SubnetId() != null) {
            sb.append("Ec2SubnetId: " + this.getEc2SubnetId() + ",");
        }
        if (this.getEmrManagedMasterSecurityGroup() != null) {
            sb.append("EmrManagedMasterSecurityGroup: " + this.getEmrManagedMasterSecurityGroup() + ",");
        }
        if (this.getEmrManagedSlaveSecurityGroup() != null) {
            sb.append("EmrManagedSlaveSecurityGroup: " + this.getEmrManagedSlaveSecurityGroup() + ",");
        }
        if (this.getAdditionalMasterSecurityGroups() != null) {
            sb.append("AdditionalMasterSecurityGroups: " + this.getAdditionalMasterSecurityGroups() + ",");
        }
        if (this.getAdditionalSlaveSecurityGroups() != null) {
            sb.append("AdditionalSlaveSecurityGroups: " + this.getAdditionalSlaveSecurityGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobFlowInstancesConfig)) {
            return false;
        }
        JobFlowInstancesConfig other = (JobFlowInstancesConfig)obj;
        if (other.getMasterInstanceType() == null ^ this.getMasterInstanceType() == null) {
            return false;
        }
        if (other.getMasterInstanceType() != null && !other.getMasterInstanceType().equals(this.getMasterInstanceType())) {
            return false;
        }
        if (other.getSlaveInstanceType() == null ^ this.getSlaveInstanceType() == null) {
            return false;
        }
        if (other.getSlaveInstanceType() != null && !other.getSlaveInstanceType().equals(this.getSlaveInstanceType())) {
            return false;
        }
        if (other.getInstanceCount() == null ^ this.getInstanceCount() == null) {
            return false;
        }
        if (other.getInstanceCount() != null && !other.getInstanceCount().equals(this.getInstanceCount())) {
            return false;
        }
        if (other.getInstanceGroups() == null ^ this.getInstanceGroups() == null) {
            return false;
        }
        if (other.getInstanceGroups() != null && !other.getInstanceGroups().equals(this.getInstanceGroups())) {
            return false;
        }
        if (other.getEc2KeyName() == null ^ this.getEc2KeyName() == null) {
            return false;
        }
        if (other.getEc2KeyName() != null && !other.getEc2KeyName().equals(this.getEc2KeyName())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.getKeepJobFlowAliveWhenNoSteps() == null ^ this.getKeepJobFlowAliveWhenNoSteps() == null) {
            return false;
        }
        if (other.getKeepJobFlowAliveWhenNoSteps() != null && !other.getKeepJobFlowAliveWhenNoSteps().equals(this.getKeepJobFlowAliveWhenNoSteps())) {
            return false;
        }
        if (other.getTerminationProtected() == null ^ this.getTerminationProtected() == null) {
            return false;
        }
        if (other.getTerminationProtected() != null && !other.getTerminationProtected().equals(this.getTerminationProtected())) {
            return false;
        }
        if (other.getHadoopVersion() == null ^ this.getHadoopVersion() == null) {
            return false;
        }
        if (other.getHadoopVersion() != null && !other.getHadoopVersion().equals(this.getHadoopVersion())) {
            return false;
        }
        if (other.getEc2SubnetId() == null ^ this.getEc2SubnetId() == null) {
            return false;
        }
        if (other.getEc2SubnetId() != null && !other.getEc2SubnetId().equals(this.getEc2SubnetId())) {
            return false;
        }
        if (other.getEmrManagedMasterSecurityGroup() == null ^ this.getEmrManagedMasterSecurityGroup() == null) {
            return false;
        }
        if (other.getEmrManagedMasterSecurityGroup() != null && !other.getEmrManagedMasterSecurityGroup().equals(this.getEmrManagedMasterSecurityGroup())) {
            return false;
        }
        if (other.getEmrManagedSlaveSecurityGroup() == null ^ this.getEmrManagedSlaveSecurityGroup() == null) {
            return false;
        }
        if (other.getEmrManagedSlaveSecurityGroup() != null && !other.getEmrManagedSlaveSecurityGroup().equals(this.getEmrManagedSlaveSecurityGroup())) {
            return false;
        }
        if (other.getAdditionalMasterSecurityGroups() == null ^ this.getAdditionalMasterSecurityGroups() == null) {
            return false;
        }
        if (other.getAdditionalMasterSecurityGroups() != null && !other.getAdditionalMasterSecurityGroups().equals(this.getAdditionalMasterSecurityGroups())) {
            return false;
        }
        if (other.getAdditionalSlaveSecurityGroups() == null ^ this.getAdditionalSlaveSecurityGroups() == null) {
            return false;
        }
        return other.getAdditionalSlaveSecurityGroups() == null || other.getAdditionalSlaveSecurityGroups().equals(this.getAdditionalSlaveSecurityGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMasterInstanceType() == null ? 0 : this.getMasterInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getSlaveInstanceType() == null ? 0 : this.getSlaveInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCount() == null ? 0 : this.getInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceGroups() == null ? 0 : this.getInstanceGroups().hashCode());
        hashCode = 31 * hashCode + (this.getEc2KeyName() == null ? 0 : this.getEc2KeyName().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getKeepJobFlowAliveWhenNoSteps() == null ? 0 : this.getKeepJobFlowAliveWhenNoSteps().hashCode());
        hashCode = 31 * hashCode + (this.getTerminationProtected() == null ? 0 : this.getTerminationProtected().hashCode());
        hashCode = 31 * hashCode + (this.getHadoopVersion() == null ? 0 : this.getHadoopVersion().hashCode());
        hashCode = 31 * hashCode + (this.getEc2SubnetId() == null ? 0 : this.getEc2SubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getEmrManagedMasterSecurityGroup() == null ? 0 : this.getEmrManagedMasterSecurityGroup().hashCode());
        hashCode = 31 * hashCode + (this.getEmrManagedSlaveSecurityGroup() == null ? 0 : this.getEmrManagedSlaveSecurityGroup().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalMasterSecurityGroups() == null ? 0 : this.getAdditionalMasterSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalSlaveSecurityGroups() == null ? 0 : this.getAdditionalSlaveSecurityGroups().hashCode());
        return hashCode;
    }

    public JobFlowInstancesConfig clone() {
        try {
            return (JobFlowInstancesConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

