/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.services.codepipeline.model.ArtifactStore;
import com.amazonaws.services.codepipeline.model.StageDeclaration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PipelineDeclaration
implements Serializable,
Cloneable {
    private String name;
    private String roleArn;
    private ArtifactStore artifactStore;
    private List<StageDeclaration> stages;
    private Integer version;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PipelineDeclaration withName(String name) {
        this.setName(name);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public PipelineDeclaration withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setArtifactStore(ArtifactStore artifactStore) {
        this.artifactStore = artifactStore;
    }

    public ArtifactStore getArtifactStore() {
        return this.artifactStore;
    }

    public PipelineDeclaration withArtifactStore(ArtifactStore artifactStore) {
        this.setArtifactStore(artifactStore);
        return this;
    }

    public List<StageDeclaration> getStages() {
        return this.stages;
    }

    public void setStages(Collection<StageDeclaration> stages) {
        if (stages == null) {
            this.stages = null;
            return;
        }
        this.stages = new ArrayList<StageDeclaration>(stages);
    }

    public PipelineDeclaration withStages(StageDeclaration ... stages) {
        if (this.stages == null) {
            this.setStages(new ArrayList<StageDeclaration>(stages.length));
        }
        for (StageDeclaration ele : stages) {
            this.stages.add(ele);
        }
        return this;
    }

    public PipelineDeclaration withStages(Collection<StageDeclaration> stages) {
        this.setStages(stages);
        return this;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getVersion() {
        return this.version;
    }

    public PipelineDeclaration withVersion(Integer version) {
        this.setVersion(version);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: " + this.getRoleArn() + ",");
        }
        if (this.getArtifactStore() != null) {
            sb.append("ArtifactStore: " + this.getArtifactStore() + ",");
        }
        if (this.getStages() != null) {
            sb.append("Stages: " + this.getStages() + ",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: " + this.getVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineDeclaration)) {
            return false;
        }
        PipelineDeclaration other = (PipelineDeclaration)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getArtifactStore() == null ^ this.getArtifactStore() == null) {
            return false;
        }
        if (other.getArtifactStore() != null && !other.getArtifactStore().equals(this.getArtifactStore())) {
            return false;
        }
        if (other.getStages() == null ^ this.getStages() == null) {
            return false;
        }
        if (other.getStages() != null && !other.getStages().equals(this.getStages())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        return other.getVersion() == null || other.getVersion().equals(this.getVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getArtifactStore() == null ? 0 : this.getArtifactStore().hashCode());
        hashCode = 31 * hashCode + (this.getStages() == null ? 0 : this.getStages().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return hashCode;
    }

    public PipelineDeclaration clone() {
        try {
            return (PipelineDeclaration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

