/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.GenericRevisionInfo;
import com.amazonaws.util.json.JSONWriter;

public class GenericRevisionInfoJsonMarshaller {
    private static GenericRevisionInfoJsonMarshaller instance;

    public void marshall(GenericRevisionInfo genericRevisionInfo, JSONWriter jsonWriter) {
        if (genericRevisionInfo == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList deploymentGroupsList;
            jsonWriter.object();
            if (genericRevisionInfo.getDescription() != null) {
                jsonWriter.key("description").value(genericRevisionInfo.getDescription());
            }
            if (!(deploymentGroupsList = (SdkInternalList)genericRevisionInfo.getDeploymentGroups()).isEmpty() || !deploymentGroupsList.isAutoConstruct()) {
                jsonWriter.key("deploymentGroups");
                jsonWriter.array();
                for (String deploymentGroupsListValue : deploymentGroupsList) {
                    if (deploymentGroupsListValue == null) continue;
                    jsonWriter.value(deploymentGroupsListValue);
                }
                jsonWriter.endArray();
            }
            if (genericRevisionInfo.getFirstUsedTime() != null) {
                jsonWriter.key("firstUsedTime").value(genericRevisionInfo.getFirstUsedTime());
            }
            if (genericRevisionInfo.getLastUsedTime() != null) {
                jsonWriter.key("lastUsedTime").value(genericRevisionInfo.getLastUsedTime());
            }
            if (genericRevisionInfo.getRegisterTime() != null) {
                jsonWriter.key("registerTime").value(genericRevisionInfo.getRegisterTime());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GenericRevisionInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GenericRevisionInfoJsonMarshaller();
        }
        return instance;
    }
}

