/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.DeleteBasePathMappingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteBasePathMappingRequestMarshaller
implements Marshaller<Request<DeleteBasePathMappingRequest>, DeleteBasePathMappingRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DeleteBasePathMappingRequest> marshall(DeleteBasePathMappingRequest deleteBasePathMappingRequest) {
        if (deleteBasePathMappingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteBasePathMappingRequest> request = new DefaultRequest<DeleteBasePathMappingRequest>(deleteBasePathMappingRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/domainnames/{domain_name}/basepathmappings/{base_path}";
        uriResourcePath = uriResourcePath.replace("{domain_name}", deleteBasePathMappingRequest.getDomainName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteBasePathMappingRequest.getDomainName()));
        uriResourcePath = uriResourcePath.replace("{base_path}", deleteBasePathMappingRequest.getBasePath() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteBasePathMappingRequest.getBasePath()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

