/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.http.timertask.HttpRequestAbortTask;
import com.amazonaws.http.timertask.HttpRequestAbortTaskTracker;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.methods.HttpRequestBase;

@ThreadSafe
public class HttpRequestTimer {
    private final ScheduledThreadPoolExecutor executor;
    private final long requestTimeoutMillis;
    private final boolean enabled;

    private static ScheduledThreadPoolExecutor createExecutor() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(5);
        HttpRequestTimer.safeSetRemoveOnCancel(executor);
        executor.setKeepAliveTime(5L, TimeUnit.SECONDS);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private static void safeSetRemoveOnCancel(ScheduledThreadPoolExecutor executor) {
        try {
            executor.getClass().getMethod("setRemoveOnCancelPolicy", Boolean.TYPE).invoke((Object)executor, Boolean.TRUE);
        }
        catch (IllegalAccessException e) {
            HttpRequestTimer.throwSetRemoveOnCancelException(e);
        }
        catch (IllegalArgumentException e) {
            HttpRequestTimer.throwSetRemoveOnCancelException(e);
        }
        catch (InvocationTargetException e) {
            HttpRequestTimer.throwSetRemoveOnCancelException(e.getCause());
        }
        catch (NoSuchMethodException e) {
            throw new AmazonClientException("The request timeout feature is only available for Java 1.7 and above.");
        }
        catch (SecurityException e) {
            throw new AmazonClientException("The request timeout feature needs additional permissions to function.", e);
        }
    }

    private static void throwSetRemoveOnCancelException(Throwable cause) {
        throw new AmazonClientException("Unable to setRemoveOnCancelPolicy for request timeout thread pool", cause);
    }

    public HttpRequestTimer(ClientConfiguration config) {
        this.requestTimeoutMillis = config.getRequestTimeout();
        this.enabled = this.requestTimeoutMillis > 0L;
        this.executor = this.enabled ? HttpRequestTimer.createExecutor() : null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public HttpRequestAbortTaskTracker schedule(HttpRequestBase apacheRequest) {
        if (!this.enabled) {
            throw new IllegalStateException("Trying to schedule a task on a disabled timer.");
        }
        HttpRequestAbortTask timerTask = new HttpRequestAbortTask(apacheRequest);
        ScheduledFuture<?> timerTaskFuture = this.executor.schedule(timerTask, this.requestTimeoutMillis, TimeUnit.MILLISECONDS);
        return new HttpRequestAbortTaskTracker(timerTask, timerTaskFuture);
    }

    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    ScheduledThreadPoolExecutor getExecutor() {
        return this.executor;
    }
}

