/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.kinesisfirehose.model.S3DestinationConfiguration;
import com.amazonaws.services.kinesisfirehose.model.transform.BufferingHintsJsonMarshaller;
import com.amazonaws.services.kinesisfirehose.model.transform.EncryptionConfigurationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class S3DestinationConfigurationJsonMarshaller {
    private static S3DestinationConfigurationJsonMarshaller instance;

    public void marshall(S3DestinationConfiguration s3DestinationConfiguration, JSONWriter jsonWriter) {
        if (s3DestinationConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (s3DestinationConfiguration.getRoleARN() != null) {
                jsonWriter.key("RoleARN").value(s3DestinationConfiguration.getRoleARN());
            }
            if (s3DestinationConfiguration.getBucketARN() != null) {
                jsonWriter.key("BucketARN").value(s3DestinationConfiguration.getBucketARN());
            }
            if (s3DestinationConfiguration.getPrefix() != null) {
                jsonWriter.key("Prefix").value(s3DestinationConfiguration.getPrefix());
            }
            if (s3DestinationConfiguration.getBufferingHints() != null) {
                jsonWriter.key("BufferingHints");
                BufferingHintsJsonMarshaller.getInstance().marshall(s3DestinationConfiguration.getBufferingHints(), jsonWriter);
            }
            if (s3DestinationConfiguration.getCompressionFormat() != null) {
                jsonWriter.key("CompressionFormat").value(s3DestinationConfiguration.getCompressionFormat());
            }
            if (s3DestinationConfiguration.getEncryptionConfiguration() != null) {
                jsonWriter.key("EncryptionConfiguration");
                EncryptionConfigurationJsonMarshaller.getInstance().marshall(s3DestinationConfiguration.getEncryptionConfiguration(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3DestinationConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3DestinationConfigurationJsonMarshaller();
        }
        return instance;
    }
}

