/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import com.amazonaws.util.Throwables;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;

public class JsonMarshaller<T>
implements DynamoDBMarshaller<T> {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectWriter writer = mapper.writer();

    @Override
    public String marshall(T obj) {
        try {
            return writer.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw Throwables.failure(e, "Unable to marshall the instance of " + obj.getClass() + "into a string");
        }
    }

    @Override
    public T unmarshall(Class<T> clazz, String json) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw Throwables.failure(e, "Unable to unmarshall the string " + json + "into " + clazz);
        }
    }
}

