/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.cloudtrail.AWSCloudTrail;
import com.amazonaws.services.cloudtrail.model.AddTagsRequest;
import com.amazonaws.services.cloudtrail.model.AddTagsResult;
import com.amazonaws.services.cloudtrail.model.CloudTrailARNInvalidException;
import com.amazonaws.services.cloudtrail.model.CloudWatchLogsDeliveryUnavailableException;
import com.amazonaws.services.cloudtrail.model.CreateTrailRequest;
import com.amazonaws.services.cloudtrail.model.CreateTrailResult;
import com.amazonaws.services.cloudtrail.model.DeleteTrailRequest;
import com.amazonaws.services.cloudtrail.model.DeleteTrailResult;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsRequest;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsResult;
import com.amazonaws.services.cloudtrail.model.GetTrailStatusRequest;
import com.amazonaws.services.cloudtrail.model.GetTrailStatusResult;
import com.amazonaws.services.cloudtrail.model.InsufficientEncryptionPolicyException;
import com.amazonaws.services.cloudtrail.model.InsufficientS3BucketPolicyException;
import com.amazonaws.services.cloudtrail.model.InsufficientSnsTopicPolicyException;
import com.amazonaws.services.cloudtrail.model.InvalidCloudWatchLogsLogGroupArnException;
import com.amazonaws.services.cloudtrail.model.InvalidCloudWatchLogsRoleArnException;
import com.amazonaws.services.cloudtrail.model.InvalidKmsKeyIdException;
import com.amazonaws.services.cloudtrail.model.InvalidLookupAttributesException;
import com.amazonaws.services.cloudtrail.model.InvalidMaxResultsException;
import com.amazonaws.services.cloudtrail.model.InvalidNextTokenException;
import com.amazonaws.services.cloudtrail.model.InvalidS3BucketNameException;
import com.amazonaws.services.cloudtrail.model.InvalidS3PrefixException;
import com.amazonaws.services.cloudtrail.model.InvalidSnsTopicNameException;
import com.amazonaws.services.cloudtrail.model.InvalidTagParameterException;
import com.amazonaws.services.cloudtrail.model.InvalidTimeRangeException;
import com.amazonaws.services.cloudtrail.model.InvalidTokenException;
import com.amazonaws.services.cloudtrail.model.InvalidTrailNameException;
import com.amazonaws.services.cloudtrail.model.KmsKeyDisabledException;
import com.amazonaws.services.cloudtrail.model.KmsKeyNotFoundException;
import com.amazonaws.services.cloudtrail.model.ListPublicKeysRequest;
import com.amazonaws.services.cloudtrail.model.ListPublicKeysResult;
import com.amazonaws.services.cloudtrail.model.ListTagsRequest;
import com.amazonaws.services.cloudtrail.model.ListTagsResult;
import com.amazonaws.services.cloudtrail.model.LookupEventsRequest;
import com.amazonaws.services.cloudtrail.model.LookupEventsResult;
import com.amazonaws.services.cloudtrail.model.MaximumNumberOfTrailsExceededException;
import com.amazonaws.services.cloudtrail.model.OperationNotPermittedException;
import com.amazonaws.services.cloudtrail.model.RemoveTagsRequest;
import com.amazonaws.services.cloudtrail.model.RemoveTagsResult;
import com.amazonaws.services.cloudtrail.model.ResourceNotFoundException;
import com.amazonaws.services.cloudtrail.model.ResourceTypeNotSupportedException;
import com.amazonaws.services.cloudtrail.model.S3BucketDoesNotExistException;
import com.amazonaws.services.cloudtrail.model.StartLoggingRequest;
import com.amazonaws.services.cloudtrail.model.StartLoggingResult;
import com.amazonaws.services.cloudtrail.model.StopLoggingRequest;
import com.amazonaws.services.cloudtrail.model.StopLoggingResult;
import com.amazonaws.services.cloudtrail.model.TagsLimitExceededException;
import com.amazonaws.services.cloudtrail.model.TrailAlreadyExistsException;
import com.amazonaws.services.cloudtrail.model.TrailNotFoundException;
import com.amazonaws.services.cloudtrail.model.TrailNotProvidedException;
import com.amazonaws.services.cloudtrail.model.UnsupportedOperationException;
import com.amazonaws.services.cloudtrail.model.UpdateTrailRequest;
import com.amazonaws.services.cloudtrail.model.UpdateTrailResult;
import com.amazonaws.services.cloudtrail.model.transform.AddTagsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.AddTagsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.CreateTrailRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.CreateTrailResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DeleteTrailRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DeleteTrailResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DescribeTrailsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DescribeTrailsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.GetTrailStatusRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.GetTrailStatusResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListPublicKeysRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListPublicKeysResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListTagsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListTagsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.LookupEventsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.LookupEventsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.RemoveTagsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.RemoveTagsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StartLoggingRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StartLoggingResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StopLoggingRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StopLoggingResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.UpdateTrailRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.UpdateTrailResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSCloudTrailClient
extends AmazonWebServiceClient
implements AWSCloudTrail {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCloudTrail.class);
    private static final String DEFAULT_SIGNING_NAME = "cloudtrail";
    private static final String DEFAULT_ENDPOINT_PREFIX = "cloudtrail";
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AWSCloudTrailClient() {
        this(new DefaultAWSCredentialsProviderChain(), PredefinedClientConfigurations.defaultConfig());
    }

    public AWSCloudTrailClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSCloudTrailClient(AWSCredentials awsCredentials) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig());
    }

    public AWSCloudTrailClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSCloudTrailClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig());
    }

    public AWSCloudTrailClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSCloudTrailClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidNextTokenException.class, "InvalidNextTokenException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(KmsKeyNotFoundException.class, "KmsKeyNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(TrailNotFoundException.class, "TrailNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(KmsKeyDisabledException.class, "KmsKeyDisabledException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(TrailAlreadyExistsException.class, "TrailAlreadyExistsException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(OperationNotPermittedException.class, "OperationNotPermittedException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidS3PrefixException.class, "InvalidS3PrefixException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(CloudTrailARNInvalidException.class, "CloudTrailARNInvalidException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidTimeRangeException.class, "InvalidTimeRangeException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(S3BucketDoesNotExistException.class, "S3BucketDoesNotExistException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ResourceTypeNotSupportedException.class, "ResourceTypeNotSupportedException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(UnsupportedOperationException.class, "UnsupportedOperationException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InsufficientEncryptionPolicyException.class, "InsufficientEncryptionPolicyException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidLookupAttributesException.class, "InvalidLookupAttributesException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(MaximumNumberOfTrailsExceededException.class, "MaximumNumberOfTrailsExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidMaxResultsException.class, "InvalidMaxResultsException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidCloudWatchLogsRoleArnException.class, "InvalidCloudWatchLogsRoleArnException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InsufficientSnsTopicPolicyException.class, "InsufficientSnsTopicPolicyException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidSnsTopicNameException.class, "InvalidSnsTopicNameException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidCloudWatchLogsLogGroupArnException.class, "InvalidCloudWatchLogsLogGroupArnException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidTokenException.class, "InvalidTokenException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(CloudWatchLogsDeliveryUnavailableException.class, "CloudWatchLogsDeliveryUnavailableException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InsufficientS3BucketPolicyException.class, "InsufficientS3BucketPolicyException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidS3BucketNameException.class, "InvalidS3BucketNameException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(TrailNotProvidedException.class, "TrailNotProvidedException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidKmsKeyIdException.class, "InvalidKmsKeyIdException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidTagParameterException.class, "InvalidTagParameterException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(TagsLimitExceededException.class, "TagsLimitExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ResourceNotFoundException.class, "ResourceNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidTrailNameException.class, "InvalidTrailNameException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setEndpoint("cloudtrail.us-east-1.amazonaws.com");
        this.setServiceNameIntern("cloudtrail");
        this.setEndpointPrefix("cloudtrail");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudtrail/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudtrail/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsResult addTags(AddTagsRequest addTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddTagsRequestMarshaller().marshall(addTagsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<AddTagsResult> responseHandler = new JsonResponseHandler<AddTagsResult>(new AddTagsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            AddTagsResult addTagsResult = (AddTagsResult)response.getAwsResponse();
            return addTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrailResult createTrail(CreateTrailRequest createTrailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTrailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTrailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTrailRequestMarshaller().marshall(createTrailRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<CreateTrailResult> responseHandler = new JsonResponseHandler<CreateTrailResult>(new CreateTrailResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            CreateTrailResult createTrailResult = (CreateTrailResult)response.getAwsResponse();
            return createTrailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTrailResult deleteTrail(DeleteTrailRequest deleteTrailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTrailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTrailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTrailRequestMarshaller().marshall(deleteTrailRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DeleteTrailResult> responseHandler = new JsonResponseHandler<DeleteTrailResult>(new DeleteTrailResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTrailResult deleteTrailResult = (DeleteTrailResult)response.getAwsResponse();
            return deleteTrailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrailsResult describeTrails(DescribeTrailsRequest describeTrailsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTrailsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTrailsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTrailsRequestMarshaller().marshall(describeTrailsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DescribeTrailsResult> responseHandler = new JsonResponseHandler<DescribeTrailsResult>(new DescribeTrailsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTrailsResult describeTrailsResult = (DescribeTrailsResult)response.getAwsResponse();
            return describeTrailsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeTrailsResult describeTrails() {
        return this.describeTrails(new DescribeTrailsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTrailStatusResult getTrailStatus(GetTrailStatusRequest getTrailStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTrailStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTrailStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTrailStatusRequestMarshaller().marshall(getTrailStatusRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<GetTrailStatusResult> responseHandler = new JsonResponseHandler<GetTrailStatusResult>(new GetTrailStatusResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            GetTrailStatusResult getTrailStatusResult = (GetTrailStatusResult)response.getAwsResponse();
            return getTrailStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPublicKeysResult listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPublicKeysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPublicKeysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPublicKeysRequestMarshaller().marshall(listPublicKeysRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListPublicKeysResult> responseHandler = new JsonResponseHandler<ListPublicKeysResult>(new ListPublicKeysResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListPublicKeysResult listPublicKeysResult = (ListPublicKeysResult)response.getAwsResponse();
            return listPublicKeysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPublicKeysResult listPublicKeys() {
        return this.listPublicKeys(new ListPublicKeysRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsResult listTags(ListTagsRequest listTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsRequestMarshaller().marshall(listTagsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListTagsResult> responseHandler = new JsonResponseHandler<ListTagsResult>(new ListTagsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsResult listTagsResult = (ListTagsResult)response.getAwsResponse();
            return listTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupEventsResult lookupEvents(LookupEventsRequest lookupEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(lookupEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<LookupEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new LookupEventsRequestMarshaller().marshall(lookupEventsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<LookupEventsResult> responseHandler = new JsonResponseHandler<LookupEventsResult>(new LookupEventsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            LookupEventsResult lookupEventsResult = (LookupEventsResult)response.getAwsResponse();
            return lookupEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public LookupEventsResult lookupEvents() {
        return this.lookupEvents(new LookupEventsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsResult removeTags(RemoveTagsRequest removeTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveTagsRequestMarshaller().marshall(removeTagsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<RemoveTagsResult> responseHandler = new JsonResponseHandler<RemoveTagsResult>(new RemoveTagsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            RemoveTagsResult removeTagsResult = (RemoveTagsResult)response.getAwsResponse();
            return removeTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartLoggingResult startLogging(StartLoggingRequest startLoggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startLoggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartLoggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartLoggingRequestMarshaller().marshall(startLoggingRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<StartLoggingResult> responseHandler = new JsonResponseHandler<StartLoggingResult>(new StartLoggingResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            StartLoggingResult startLoggingResult = (StartLoggingResult)response.getAwsResponse();
            return startLoggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopLoggingResult stopLogging(StopLoggingRequest stopLoggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopLoggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopLoggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopLoggingRequestMarshaller().marshall(stopLoggingRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<StopLoggingResult> responseHandler = new JsonResponseHandler<StopLoggingResult>(new StopLoggingResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            StopLoggingResult stopLoggingResult = (StopLoggingResult)response.getAwsResponse();
            return stopLoggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTrailResult updateTrail(UpdateTrailRequest updateTrailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTrailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTrailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTrailRequestMarshaller().marshall(updateTrailRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<UpdateTrailResult> responseHandler = new JsonResponseHandler<UpdateTrailResult>(new UpdateTrailResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateTrailResult updateTrailResult = (UpdateTrailResult)response.getAwsResponse();
            return updateTrailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

