/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.opsworks.model.SslConfiguration;
import com.amazonaws.util.json.JSONWriter;

public class SslConfigurationJsonMarshaller {
    private static SslConfigurationJsonMarshaller instance;

    public void marshall(SslConfiguration sslConfiguration, JSONWriter jsonWriter) {
        if (sslConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (sslConfiguration.getCertificate() != null) {
                jsonWriter.key("Certificate").value(sslConfiguration.getCertificate());
            }
            if (sslConfiguration.getPrivateKey() != null) {
                jsonWriter.key("PrivateKey").value(sslConfiguration.getPrivateKey());
            }
            if (sslConfiguration.getChain() != null) {
                jsonWriter.key("Chain").value(sslConfiguration.getChain());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SslConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SslConfigurationJsonMarshaller();
        }
        return instance;
    }
}

