/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.AutoScalingThresholds;
import com.amazonaws.util.json.JSONWriter;

public class AutoScalingThresholdsJsonMarshaller {
    private static AutoScalingThresholdsJsonMarshaller instance;

    public void marshall(AutoScalingThresholds autoScalingThresholds, JSONWriter jsonWriter) {
        if (autoScalingThresholds == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList alarmsList;
            jsonWriter.object();
            if (autoScalingThresholds.getInstanceCount() != null) {
                jsonWriter.key("InstanceCount").value(autoScalingThresholds.getInstanceCount());
            }
            if (autoScalingThresholds.getThresholdsWaitTime() != null) {
                jsonWriter.key("ThresholdsWaitTime").value(autoScalingThresholds.getThresholdsWaitTime());
            }
            if (autoScalingThresholds.getIgnoreMetricsTime() != null) {
                jsonWriter.key("IgnoreMetricsTime").value(autoScalingThresholds.getIgnoreMetricsTime());
            }
            if (autoScalingThresholds.getCpuThreshold() != null) {
                jsonWriter.key("CpuThreshold").value(autoScalingThresholds.getCpuThreshold());
            }
            if (autoScalingThresholds.getMemoryThreshold() != null) {
                jsonWriter.key("MemoryThreshold").value(autoScalingThresholds.getMemoryThreshold());
            }
            if (autoScalingThresholds.getLoadThreshold() != null) {
                jsonWriter.key("LoadThreshold").value(autoScalingThresholds.getLoadThreshold());
            }
            if (!(alarmsList = (SdkInternalList)autoScalingThresholds.getAlarms()).isEmpty() || !alarmsList.isAutoConstruct()) {
                jsonWriter.key("Alarms");
                jsonWriter.array();
                for (String alarmsListValue : alarmsList) {
                    if (alarmsListValue == null) continue;
                    jsonWriter.value(alarmsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AutoScalingThresholdsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AutoScalingThresholdsJsonMarshaller();
        }
        return instance;
    }
}

