/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.iot.model.KeyPair;
import com.amazonaws.util.json.JSONWriter;

public class KeyPairJsonMarshaller {
    private static KeyPairJsonMarshaller instance;

    public void marshall(KeyPair keyPair, JSONWriter jsonWriter) {
        if (keyPair == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (keyPair.getPublicKey() != null) {
                jsonWriter.key("PublicKey").value(keyPair.getPublicKey());
            }
            if (keyPair.getPrivateKey() != null) {
                jsonWriter.key("PrivateKey").value(keyPair.getPrivateKey());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static KeyPairJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new KeyPairJsonMarshaller();
        }
        return instance;
    }
}

