/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.GetPolicyVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetPolicyVersionRequestMarshaller
implements Marshaller<Request<GetPolicyVersionRequest>, GetPolicyVersionRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<GetPolicyVersionRequest> marshall(GetPolicyVersionRequest getPolicyVersionRequest) {
        if (getPolicyVersionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetPolicyVersionRequest> request = new DefaultRequest<GetPolicyVersionRequest>(getPolicyVersionRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/policies/{policyName}/version/{policyVersionId}";
        uriResourcePath = uriResourcePath.replace("{policyName}", getPolicyVersionRequest.getPolicyName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getPolicyVersionRequest.getPolicyName()));
        uriResourcePath = uriResourcePath.replace("{policyVersionId}", getPolicyVersionRequest.getPolicyVersionId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(getPolicyVersionRequest.getPolicyVersionId()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

