/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.glacier.model.DataRetrievalPolicy;
import com.amazonaws.services.glacier.model.DataRetrievalRule;
import com.amazonaws.services.glacier.model.SetDataRetrievalPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SetDataRetrievalPolicyRequestMarshaller
implements Marshaller<Request<SetDataRetrievalPolicyRequest>, SetDataRetrievalPolicyRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<SetDataRetrievalPolicyRequest> marshall(SetDataRetrievalPolicyRequest setDataRetrievalPolicyRequest) {
        if (setDataRetrievalPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetDataRetrievalPolicyRequest> request = new DefaultRequest<SetDataRetrievalPolicyRequest>(setDataRetrievalPolicyRequest, "AmazonGlacier");
        String target = "Glacier.SetDataRetrievalPolicy";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("accountId")) {
            String value;
            String name = DYNAMIC_QUERY_PARAMS.get("accountId");
            String string = value = setDataRetrievalPolicyRequest.getAccountId() == null ? null : StringUtils.fromString(setDataRetrievalPolicyRequest.getAccountId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{accountId}", setDataRetrievalPolicyRequest.getAccountId() == null ? "" : StringUtils.fromString(setDataRetrievalPolicyRequest.getAccountId()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            DataRetrievalPolicy policy = setDataRetrievalPolicyRequest.getPolicy();
            if (policy != null) {
                jsonWriter.key("Policy");
                jsonWriter.object();
                ListWithAutoConstructFlag rulesList = (ListWithAutoConstructFlag)policy.getRules();
                if (!(rulesList == null || rulesList.isAutoConstruct() && rulesList.isEmpty())) {
                    jsonWriter.key("Rules");
                    jsonWriter.array();
                    for (DataRetrievalRule rulesListValue : rulesList) {
                        if (rulesListValue == null) continue;
                        jsonWriter.object();
                        if (rulesListValue.getStrategy() != null) {
                            jsonWriter.key("Strategy").value(rulesListValue.getStrategy());
                        }
                        if (rulesListValue.getBytesPerHour() != null) {
                            jsonWriter.key("BytesPerHour").value(rulesListValue.getBytesPerHour());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    static {
        String path = "/{accountId}/policies/data-retrieval";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

