/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticsearch.model.DeleteElasticsearchDomainRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteElasticsearchDomainRequestMarshaller
implements Marshaller<Request<DeleteElasticsearchDomainRequest>, DeleteElasticsearchDomainRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<DeleteElasticsearchDomainRequest> marshall(DeleteElasticsearchDomainRequest deleteElasticsearchDomainRequest) {
        if (deleteElasticsearchDomainRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteElasticsearchDomainRequest> request = new DefaultRequest<DeleteElasticsearchDomainRequest>(deleteElasticsearchDomainRequest, "AWSElasticsearch");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/2015-01-01/es/domain/{DomainName}";
        uriResourcePath = uriResourcePath.replace("{DomainName}", deleteElasticsearchDomainRequest.getDomainName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(deleteElasticsearchDomainRequest.getDomainName()));
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

