/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.Evaluation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PutEvaluationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<Evaluation> evaluations;
    private String resultToken;

    public List<Evaluation> getEvaluations() {
        if (this.evaluations == null) {
            this.evaluations = new SdkInternalList();
        }
        return this.evaluations;
    }

    public void setEvaluations(Collection<Evaluation> evaluations) {
        if (evaluations == null) {
            this.evaluations = null;
            return;
        }
        this.evaluations = new SdkInternalList<Evaluation>(evaluations);
    }

    public PutEvaluationsRequest withEvaluations(Evaluation ... evaluations) {
        if (this.evaluations == null) {
            this.setEvaluations(new SdkInternalList<Evaluation>(evaluations.length));
        }
        for (Evaluation ele : evaluations) {
            this.evaluations.add(ele);
        }
        return this;
    }

    public PutEvaluationsRequest withEvaluations(Collection<Evaluation> evaluations) {
        this.setEvaluations(evaluations);
        return this;
    }

    public void setResultToken(String resultToken) {
        this.resultToken = resultToken;
    }

    public String getResultToken() {
        return this.resultToken;
    }

    public PutEvaluationsRequest withResultToken(String resultToken) {
        this.setResultToken(resultToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvaluations() != null) {
            sb.append("Evaluations: " + this.getEvaluations() + ",");
        }
        if (this.getResultToken() != null) {
            sb.append("ResultToken: " + this.getResultToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEvaluationsRequest)) {
            return false;
        }
        PutEvaluationsRequest other = (PutEvaluationsRequest)obj;
        if (other.getEvaluations() == null ^ this.getEvaluations() == null) {
            return false;
        }
        if (other.getEvaluations() != null && !other.getEvaluations().equals(this.getEvaluations())) {
            return false;
        }
        if (other.getResultToken() == null ^ this.getResultToken() == null) {
            return false;
        }
        return other.getResultToken() == null || other.getResultToken().equals(this.getResultToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvaluations() == null ? 0 : this.getEvaluations().hashCode());
        hashCode = 31 * hashCode + (this.getResultToken() == null ? 0 : this.getResultToken().hashCode());
        return hashCode;
    }

    @Override
    public PutEvaluationsRequest clone() {
        return (PutEvaluationsRequest)super.clone();
    }
}

