/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudtrail.model.UpdateTrailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class UpdateTrailRequestMarshaller
implements Marshaller<Request<UpdateTrailRequest>, UpdateTrailRequest> {
    @Override
    public Request<UpdateTrailRequest> marshall(UpdateTrailRequest updateTrailRequest) {
        if (updateTrailRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateTrailRequest> request = new DefaultRequest<UpdateTrailRequest>(updateTrailRequest, "AWSCloudTrail");
        request.addHeader("X-Amz-Target", "com.amazonaws.cloudtrail.v20131101.CloudTrail_20131101.UpdateTrail");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateTrailRequest.getName() != null) {
                jsonWriter.key("Name").value(updateTrailRequest.getName());
            }
            if (updateTrailRequest.getS3BucketName() != null) {
                jsonWriter.key("S3BucketName").value(updateTrailRequest.getS3BucketName());
            }
            if (updateTrailRequest.getS3KeyPrefix() != null) {
                jsonWriter.key("S3KeyPrefix").value(updateTrailRequest.getS3KeyPrefix());
            }
            if (updateTrailRequest.getSnsTopicName() != null) {
                jsonWriter.key("SnsTopicName").value(updateTrailRequest.getSnsTopicName());
            }
            if (updateTrailRequest.getIncludeGlobalServiceEvents() != null) {
                jsonWriter.key("IncludeGlobalServiceEvents").value(updateTrailRequest.getIncludeGlobalServiceEvents());
            }
            if (updateTrailRequest.getEnableLogFileValidation() != null) {
                jsonWriter.key("EnableLogFileValidation").value(updateTrailRequest.getEnableLogFileValidation());
            }
            if (updateTrailRequest.getCloudWatchLogsLogGroupArn() != null) {
                jsonWriter.key("CloudWatchLogsLogGroupArn").value(updateTrailRequest.getCloudWatchLogsLogGroupArn());
            }
            if (updateTrailRequest.getCloudWatchLogsRoleArn() != null) {
                jsonWriter.key("CloudWatchLogsRoleArn").value(updateTrailRequest.getCloudWatchLogsRoleArn());
            }
            if (updateTrailRequest.getKmsKeyId() != null) {
                jsonWriter.key("KmsKeyId").value(updateTrailRequest.getKmsKeyId());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

