/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.CreateDeploymentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateDeploymentRequestMarshaller
implements Marshaller<Request<CreateDeploymentRequest>, CreateDeploymentRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<CreateDeploymentRequest> marshall(CreateDeploymentRequest createDeploymentRequest) {
        if (createDeploymentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDeploymentRequest> request = new DefaultRequest<CreateDeploymentRequest>(createDeploymentRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/deployments";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", createDeploymentRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(createDeploymentRequest.getRestApiId()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createDeploymentRequest.getStageName() != null) {
                jsonWriter.key("stageName").value(createDeploymentRequest.getStageName());
            }
            if (createDeploymentRequest.getStageDescription() != null) {
                jsonWriter.key("stageDescription").value(createDeploymentRequest.getStageDescription());
            }
            if (createDeploymentRequest.getDescription() != null) {
                jsonWriter.key("description").value(createDeploymentRequest.getDescription());
            }
            if (createDeploymentRequest.getCacheClusterEnabled() != null) {
                jsonWriter.key("cacheClusterEnabled").value(createDeploymentRequest.getCacheClusterEnabled());
            }
            if (createDeploymentRequest.getCacheClusterSize() != null) {
                jsonWriter.key("cacheClusterSize").value(createDeploymentRequest.getCacheClusterSize());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

