/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpleemail.model.RawMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SendRawEmailRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String source;
    private ListWithAutoConstructFlag<String> destinations;
    private RawMessage rawMessage;
    private String fromArn;
    private String sourceArn;
    private String returnPathArn;

    public SendRawEmailRequest() {
    }

    public SendRawEmailRequest(RawMessage rawMessage) {
        this.setRawMessage(rawMessage);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public SendRawEmailRequest withSource(String source) {
        this.source = source;
        return this;
    }

    public List<String> getDestinations() {
        if (this.destinations == null) {
            this.destinations = new ListWithAutoConstructFlag();
            this.destinations.setAutoConstruct(true);
        }
        return this.destinations;
    }

    public void setDestinations(Collection<String> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        ListWithAutoConstructFlag destinationsCopy = new ListWithAutoConstructFlag(destinations.size());
        destinationsCopy.addAll(destinations);
        this.destinations = destinationsCopy;
    }

    public SendRawEmailRequest withDestinations(String ... destinations) {
        if (this.getDestinations() == null) {
            this.setDestinations(new ArrayList<String>(destinations.length));
        }
        for (String value : destinations) {
            this.getDestinations().add(value);
        }
        return this;
    }

    public SendRawEmailRequest withDestinations(Collection<String> destinations) {
        if (destinations == null) {
            this.destinations = null;
        } else {
            ListWithAutoConstructFlag destinationsCopy = new ListWithAutoConstructFlag(destinations.size());
            destinationsCopy.addAll(destinations);
            this.destinations = destinationsCopy;
        }
        return this;
    }

    public RawMessage getRawMessage() {
        return this.rawMessage;
    }

    public void setRawMessage(RawMessage rawMessage) {
        this.rawMessage = rawMessage;
    }

    public SendRawEmailRequest withRawMessage(RawMessage rawMessage) {
        this.rawMessage = rawMessage;
        return this;
    }

    public String getFromArn() {
        return this.fromArn;
    }

    public void setFromArn(String fromArn) {
        this.fromArn = fromArn;
    }

    public SendRawEmailRequest withFromArn(String fromArn) {
        this.fromArn = fromArn;
        return this;
    }

    public String getSourceArn() {
        return this.sourceArn;
    }

    public void setSourceArn(String sourceArn) {
        this.sourceArn = sourceArn;
    }

    public SendRawEmailRequest withSourceArn(String sourceArn) {
        this.sourceArn = sourceArn;
        return this;
    }

    public String getReturnPathArn() {
        return this.returnPathArn;
    }

    public void setReturnPathArn(String returnPathArn) {
        this.returnPathArn = returnPathArn;
    }

    public SendRawEmailRequest withReturnPathArn(String returnPathArn) {
        this.returnPathArn = returnPathArn;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSource() != null) {
            sb.append("Source: " + this.getSource() + ",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: " + this.getDestinations() + ",");
        }
        if (this.getRawMessage() != null) {
            sb.append("RawMessage: " + this.getRawMessage() + ",");
        }
        if (this.getFromArn() != null) {
            sb.append("FromArn: " + this.getFromArn() + ",");
        }
        if (this.getSourceArn() != null) {
            sb.append("SourceArn: " + this.getSourceArn() + ",");
        }
        if (this.getReturnPathArn() != null) {
            sb.append("ReturnPathArn: " + this.getReturnPathArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getRawMessage() == null ? 0 : this.getRawMessage().hashCode());
        hashCode = 31 * hashCode + (this.getFromArn() == null ? 0 : this.getFromArn().hashCode());
        hashCode = 31 * hashCode + (this.getSourceArn() == null ? 0 : this.getSourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getReturnPathArn() == null ? 0 : this.getReturnPathArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendRawEmailRequest)) {
            return false;
        }
        SendRawEmailRequest other = (SendRawEmailRequest)obj;
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getRawMessage() == null ^ this.getRawMessage() == null) {
            return false;
        }
        if (other.getRawMessage() != null && !other.getRawMessage().equals(this.getRawMessage())) {
            return false;
        }
        if (other.getFromArn() == null ^ this.getFromArn() == null) {
            return false;
        }
        if (other.getFromArn() != null && !other.getFromArn().equals(this.getFromArn())) {
            return false;
        }
        if (other.getSourceArn() == null ^ this.getSourceArn() == null) {
            return false;
        }
        if (other.getSourceArn() != null && !other.getSourceArn().equals(this.getSourceArn())) {
            return false;
        }
        if (other.getReturnPathArn() == null ^ this.getReturnPathArn() == null) {
            return false;
        }
        return other.getReturnPathArn() == null || other.getReturnPathArn().equals(this.getReturnPathArn());
    }

    @Override
    public SendRawEmailRequest clone() {
        return (SendRawEmailRequest)super.clone();
    }
}

