/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.DescribeRdsDbInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeRdsDbInstancesRequestMarshaller
implements Marshaller<Request<DescribeRdsDbInstancesRequest>, DescribeRdsDbInstancesRequest> {
    @Override
    public Request<DescribeRdsDbInstancesRequest> marshall(DescribeRdsDbInstancesRequest describeRdsDbInstancesRequest) {
        if (describeRdsDbInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeRdsDbInstancesRequest> request = new DefaultRequest<DescribeRdsDbInstancesRequest>(describeRdsDbInstancesRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeRdsDbInstances");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList rdsDbInstanceArnsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeRdsDbInstancesRequest.getStackId() != null) {
                jsonWriter.key("StackId").value(describeRdsDbInstancesRequest.getStackId());
            }
            if (!(rdsDbInstanceArnsList = (SdkInternalList)describeRdsDbInstancesRequest.getRdsDbInstanceArns()).isEmpty() || !rdsDbInstanceArnsList.isAutoConstruct()) {
                jsonWriter.key("RdsDbInstanceArns");
                jsonWriter.array();
                for (String rdsDbInstanceArnsListValue : rdsDbInstanceArnsList) {
                    if (rdsDbInstanceArnsListValue == null) continue;
                    jsonWriter.value(rdsDbInstanceArnsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

