/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.lambda.model.AliasConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAliasesResult
implements Serializable,
Cloneable {
    private String nextMarker;
    private ListWithAutoConstructFlag<AliasConfiguration> aliases;

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public ListAliasesResult withNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public List<AliasConfiguration> getAliases() {
        if (this.aliases == null) {
            this.aliases = new ListWithAutoConstructFlag();
            this.aliases.setAutoConstruct(true);
        }
        return this.aliases;
    }

    public void setAliases(Collection<AliasConfiguration> aliases) {
        if (aliases == null) {
            this.aliases = null;
            return;
        }
        ListWithAutoConstructFlag aliasesCopy = new ListWithAutoConstructFlag(aliases.size());
        aliasesCopy.addAll(aliases);
        this.aliases = aliasesCopy;
    }

    public ListAliasesResult withAliases(AliasConfiguration ... aliases) {
        if (this.getAliases() == null) {
            this.setAliases(new ArrayList<AliasConfiguration>(aliases.length));
        }
        for (AliasConfiguration value : aliases) {
            this.getAliases().add(value);
        }
        return this;
    }

    public ListAliasesResult withAliases(Collection<AliasConfiguration> aliases) {
        if (aliases == null) {
            this.aliases = null;
        } else {
            ListWithAutoConstructFlag aliasesCopy = new ListWithAutoConstructFlag(aliases.size());
            aliasesCopy.addAll(aliases);
            this.aliases = aliasesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: " + this.getNextMarker() + ",");
        }
        if (this.getAliases() != null) {
            sb.append("Aliases: " + this.getAliases());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.getAliases() == null ? 0 : this.getAliases().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAliasesResult)) {
            return false;
        }
        ListAliasesResult other = (ListAliasesResult)obj;
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getAliases() == null ^ this.getAliases() == null) {
            return false;
        }
        return other.getAliases() == null || other.getAliases().equals(this.getAliases());
    }

    public ListAliasesResult clone() {
        try {
            return (ListAliasesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

