/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.CreateTopicRuleRequest;
import com.amazonaws.services.iot.model.TopicRulePayload;
import com.amazonaws.services.iot.model.transform.ActionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class CreateTopicRuleRequestMarshaller
implements Marshaller<Request<CreateTopicRuleRequest>, CreateTopicRuleRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<CreateTopicRuleRequest> marshall(CreateTopicRuleRequest createTopicRuleRequest) {
        if (createTopicRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateTopicRuleRequest> request = new DefaultRequest<CreateTopicRuleRequest>(createTopicRuleRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/rules/{ruleName}";
        uriResourcePath = uriResourcePath.replace("{ruleName}", createTopicRuleRequest.getRuleName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(createTopicRuleRequest.getRuleName()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            TopicRulePayload topicRulePayload = createTopicRuleRequest.getTopicRulePayload();
            if (topicRulePayload != null) {
                List<Action> actionsList;
                jsonWriter.object();
                if (topicRulePayload.getSql() != null) {
                    jsonWriter.key("sql").value(topicRulePayload.getSql());
                }
                if (topicRulePayload.getDescription() != null) {
                    jsonWriter.key("description").value(topicRulePayload.getDescription());
                }
                if ((actionsList = topicRulePayload.getActions()) != null) {
                    jsonWriter.key("actions");
                    jsonWriter.array();
                    for (Action actionsListValue : actionsList) {
                        if (actionsListValue == null) continue;
                        ActionJsonMarshaller.getInstance().marshall(actionsListValue, jsonWriter);
                    }
                    jsonWriter.endArray();
                }
                if (topicRulePayload.getRuleDisabled() != null) {
                    jsonWriter.key("ruleDisabled").value(topicRulePayload.getRuleDisabled());
                }
                jsonWriter.endObject();
            }
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

