/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.MessageTypeTelemetry;
import com.amazonaws.services.inspector.model.Telemetry;
import com.amazonaws.services.inspector.model.transform.MessageTypeTelemetryJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class TelemetryJsonMarshaller {
    private static TelemetryJsonMarshaller instance;

    public void marshall(Telemetry telemetry, JSONWriter jsonWriter) {
        if (telemetry == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<MessageTypeTelemetry> messageTypeTelemetriesList;
            jsonWriter.object();
            if (telemetry.getStatus() != null) {
                jsonWriter.key("status").value(telemetry.getStatus());
            }
            if ((messageTypeTelemetriesList = telemetry.getMessageTypeTelemetries()) != null) {
                jsonWriter.key("messageTypeTelemetries");
                jsonWriter.array();
                for (MessageTypeTelemetry messageTypeTelemetriesListValue : messageTypeTelemetriesList) {
                    if (messageTypeTelemetriesListValue == null) continue;
                    MessageTypeTelemetryJsonMarshaller.getInstance().marshall(messageTypeTelemetriesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TelemetryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TelemetryJsonMarshaller();
        }
        return instance;
    }
}

