/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.inspector.model.AssessmentsFilter;
import com.amazonaws.services.inspector.model.transform.DurationRangeJsonMarshaller;
import com.amazonaws.services.inspector.model.transform.TimestampRangeJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class AssessmentsFilterJsonMarshaller {
    private static AssessmentsFilterJsonMarshaller instance;

    public void marshall(AssessmentsFilter assessmentsFilter, JSONWriter jsonWriter) {
        if (assessmentsFilter == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> assessmentStatesList;
            jsonWriter.object();
            List<String> assessmentNamePatternsList = assessmentsFilter.getAssessmentNamePatterns();
            if (assessmentNamePatternsList != null) {
                jsonWriter.key("assessmentNamePatterns");
                jsonWriter.array();
                for (String assessmentNamePatternsListValue : assessmentNamePatternsList) {
                    if (assessmentNamePatternsListValue == null) continue;
                    jsonWriter.value(assessmentNamePatternsListValue);
                }
                jsonWriter.endArray();
            }
            if ((assessmentStatesList = assessmentsFilter.getAssessmentStates()) != null) {
                jsonWriter.key("assessmentStates");
                jsonWriter.array();
                for (String assessmentStatesListValue : assessmentStatesList) {
                    if (assessmentStatesListValue == null) continue;
                    jsonWriter.value(assessmentStatesListValue);
                }
                jsonWriter.endArray();
            }
            if (assessmentsFilter.getDataCollected() != null) {
                jsonWriter.key("dataCollected").value(assessmentsFilter.getDataCollected());
            }
            if (assessmentsFilter.getStartTimeRange() != null) {
                jsonWriter.key("startTimeRange");
                TimestampRangeJsonMarshaller.getInstance().marshall(assessmentsFilter.getStartTimeRange(), jsonWriter);
            }
            if (assessmentsFilter.getEndTimeRange() != null) {
                jsonWriter.key("endTimeRange");
                TimestampRangeJsonMarshaller.getInstance().marshall(assessmentsFilter.getEndTimeRange(), jsonWriter);
            }
            if (assessmentsFilter.getDurationRange() != null) {
                jsonWriter.key("durationRange");
                DurationRangeJsonMarshaller.getInstance().marshall(assessmentsFilter.getDurationRange(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AssessmentsFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AssessmentsFilterJsonMarshaller();
        }
        return instance;
    }
}

