/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.services.elasticmapreduce.model.transform.HadoopJarStepConfigJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class StepConfigJsonMarshaller {
    private static StepConfigJsonMarshaller instance;

    public void marshall(StepConfig stepConfig, JSONWriter jsonWriter) {
        if (stepConfig == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (stepConfig.getName() != null) {
                jsonWriter.key("Name").value(stepConfig.getName());
            }
            if (stepConfig.getActionOnFailure() != null) {
                jsonWriter.key("ActionOnFailure").value(stepConfig.getActionOnFailure());
            }
            if (stepConfig.getHadoopJarStep() != null) {
                jsonWriter.key("HadoopJarStep");
                HadoopJarStepConfigJsonMarshaller.getInstance().marshall(stepConfig.getHadoopJarStep(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StepConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StepConfigJsonMarshaller();
        }
        return instance;
    }
}

