/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.KeyValue;
import com.amazonaws.util.json.JSONWriter;

public class KeyValueJsonMarshaller {
    private static KeyValueJsonMarshaller instance;

    public void marshall(KeyValue keyValue, JSONWriter jsonWriter) {
        if (keyValue == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (keyValue.getKey() != null) {
                jsonWriter.key("Key").value(keyValue.getKey());
            }
            if (keyValue.getValue() != null) {
                jsonWriter.key("Value").value(keyValue.getValue());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static KeyValueJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new KeyValueJsonMarshaller();
        }
        return instance;
    }
}

