/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.ClusterStatus;
import com.amazonaws.services.elasticmapreduce.model.transform.ClusterStateChangeReasonJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ClusterTimelineJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ClusterStatusJsonMarshaller {
    private static ClusterStatusJsonMarshaller instance;

    public void marshall(ClusterStatus clusterStatus, JSONWriter jsonWriter) {
        if (clusterStatus == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (clusterStatus.getState() != null) {
                jsonWriter.key("State").value(clusterStatus.getState());
            }
            if (clusterStatus.getStateChangeReason() != null) {
                jsonWriter.key("StateChangeReason");
                ClusterStateChangeReasonJsonMarshaller.getInstance().marshall(clusterStatus.getStateChangeReason(), jsonWriter);
            }
            if (clusterStatus.getTimeline() != null) {
                jsonWriter.key("Timeline");
                ClusterTimelineJsonMarshaller.getInstance().marshall(clusterStatus.getTimeline(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ClusterStatusJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ClusterStatusJsonMarshaller();
        }
        return instance;
    }
}

