/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;

public class TableUtils {
    private static final int DEFAULT_WAIT_TIMEOUT = 600000;
    private static final int DEFAULT_WAIT_INTERVAL = 20000;

    public static void waitUntilExists(AmazonDynamoDB dynamo, String tableName) throws InterruptedException {
        TableUtils.waitUntilExists(dynamo, tableName, 600000, 20000);
    }

    public static void waitUntilExists(AmazonDynamoDB dynamo, String tableName, int timeout, int interval) throws InterruptedException {
        TableDescription table = TableUtils.waitForTableDescription(dynamo, tableName, timeout, interval);
        if (table == null) {
            throw new AmazonClientException("Table " + tableName + " never returned a result");
        }
    }

    public static void waitUntilActive(AmazonDynamoDB dynamo, String tableName) throws InterruptedException {
        TableUtils.waitUntilActive(dynamo, tableName, 600000, 20000);
    }

    public static void waitUntilActive(AmazonDynamoDB dynamo, String tableName, int timeout, int interval) throws InterruptedException {
        TableDescription table = TableUtils.waitForTableDescription(dynamo, tableName, timeout, interval);
        if (table == null || !table.getTableStatus().equals(TableStatus.ACTIVE.toString())) {
            throw new AmazonClientException("Table " + tableName + " never became active");
        }
    }

    private static TableDescription waitForTableDescription(AmazonDynamoDB dynamo, String tableName, int timeout, int interval) throws InterruptedException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        if (interval <= 0 || interval >= timeout) {
            throw new IllegalArgumentException("Interval must be > 0 and < timeout");
        }
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)timeout;
        while (System.currentTimeMillis() < endTime) {
            try {
                TableDescription table = dynamo.describeTable(new DescribeTableRequest(tableName)).getTable();
                if (table != null) {
                    return table;
                }
            }
            catch (ResourceNotFoundException rnfe) {
                // empty catch block
            }
            Thread.sleep(interval);
        }
        return null;
    }
}

