/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directory.model.DisableSsoRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DisableSsoRequestMarshaller
implements Marshaller<Request<DisableSsoRequest>, DisableSsoRequest> {
    @Override
    public Request<DisableSsoRequest> marshall(DisableSsoRequest disableSsoRequest) {
        if (disableSsoRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DisableSsoRequest> request = new DefaultRequest<DisableSsoRequest>(disableSsoRequest, "AWSDirectoryService");
        request.addHeader("X-Amz-Target", "DirectoryService_20150416.DisableSso");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (disableSsoRequest.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value(disableSsoRequest.getDirectoryId());
            }
            if (disableSsoRequest.getUserName() != null) {
                jsonWriter.key("UserName").value(disableSsoRequest.getUserName());
            }
            if (disableSsoRequest.getPassword() != null) {
                jsonWriter.key("Password").value(disableSsoRequest.getPassword());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

