/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.ListStacksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListStacksRequestMarshaller
implements Marshaller<Request<ListStacksRequest>, ListStacksRequest> {
    @Override
    public Request<ListStacksRequest> marshall(ListStacksRequest listStacksRequest) {
        SdkInternalList stackStatusFiltersList;
        if (listStacksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListStacksRequest> request = new DefaultRequest<ListStacksRequest>(listStacksRequest, "AmazonCloudFormation");
        request.addParameter("Action", "ListStacks");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listStacksRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listStacksRequest.getNextToken()));
        }
        if (!(stackStatusFiltersList = (SdkInternalList)listStacksRequest.getStackStatusFilters()).isEmpty() || !stackStatusFiltersList.isAutoConstruct()) {
            int stackStatusFiltersListIndex = 1;
            for (String stackStatusFiltersListValue : stackStatusFiltersList) {
                if (stackStatusFiltersListValue != null) {
                    request.addParameter("stackStatusFilters.member." + stackStatusFiltersListIndex, StringUtils.fromString(stackStatusFiltersListValue));
                }
                ++stackStatusFiltersListIndex;
            }
        }
        return request;
    }
}

