/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.http;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class JsonErrorMessageParser {
    private static final List<String> DEFAULT_ERROR_MESSAGE_LOCATIONS = Arrays.asList("message", "Message", "errorMessage");
    public static final JsonErrorMessageParser DEFAULT_ERROR_MESSAGE_PARSER = new JsonErrorMessageParser(DEFAULT_ERROR_MESSAGE_LOCATIONS);
    private final List<String> errorMessageJsonLocations;

    public JsonErrorMessageParser(List<String> errorMessageJsonLocations) {
        this.errorMessageJsonLocations = new LinkedList<String>(errorMessageJsonLocations);
    }

    public String parseErrorMessage(JsonNode jsonNode) {
        for (String field : this.errorMessageJsonLocations) {
            JsonNode value = jsonNode.get(field);
            if (value == null || !value.isTextual()) continue;
            return value.asText();
        }
        return null;
    }
}

