/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.datapipeline.model.PollForTaskRequest;
import com.amazonaws.services.datapipeline.model.transform.InstanceIdentityJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class PollForTaskRequestMarshaller
implements Marshaller<Request<PollForTaskRequest>, PollForTaskRequest> {
    @Override
    public Request<PollForTaskRequest> marshall(PollForTaskRequest pollForTaskRequest) {
        if (pollForTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PollForTaskRequest> request = new DefaultRequest<PollForTaskRequest>(pollForTaskRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.PollForTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (pollForTaskRequest.getWorkerGroup() != null) {
                jsonWriter.key("workerGroup").value(pollForTaskRequest.getWorkerGroup());
            }
            if (pollForTaskRequest.getHostname() != null) {
                jsonWriter.key("hostname").value(pollForTaskRequest.getHostname());
            }
            if (pollForTaskRequest.getInstanceIdentity() != null) {
                jsonWriter.key("instanceIdentity");
                InstanceIdentityJsonMarshaller.getInstance().marshall(pollForTaskRequest.getInstanceIdentity(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

